/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.HftpFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.apache.hadoop.hdfs.web.WebHdfsTestUtil;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAuditLogs {
    static final String auditLogFile = System.getProperty("test.build.dir", "build/test") + "/audit.log";
    static final Pattern auditPattern = Pattern.compile("allowed=.*?\\sugi=.*?\\sip=/\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\scmd=.*?\\ssrc=.*?\\sdst=null\\sperm=.*?");
    static final Pattern successPattern = Pattern.compile(".*allowed=true.*");
    static final String username = "bob";
    static final String[] groups = new String[]{"group1"};
    static final String fileName = "/srcdat";
    DFSTestUtil util;
    MiniDFSCluster cluster;
    FileSystem fs;
    String[] fnames;
    Configuration conf;
    UserGroupInformation userGroupInfo;

    @Before
    public void setupCluster() throws Exception {
        this.conf = new HdfsConfiguration();
        long precision = 1L;
        this.conf.setLong("dfs.namenode.accesstime.precision", 1L);
        this.conf.setLong("dfs.blockreport.intervalMsec", 10000L);
        this.conf.setBoolean("dfs.webhdfs.enabled", true);
        this.util = new DFSTestUtil.Builder().setName("TestAuditAllowed").setNumFiles(20).build();
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(4).build();
        this.fs = this.cluster.getFileSystem();
        this.util.createFiles(this.fs, fileName);
        this.fnames = this.util.getFileNames(fileName);
        this.util.waitReplication(this.fs, fileName, (short)3);
        this.userGroupInfo = UserGroupInformation.createUserForTesting((String)username, (String[])groups);
    }

    @After
    public void teardownCluster() throws Exception {
        this.util.cleanup(this.fs, fileName);
        this.fs.close();
        this.cluster.shutdown();
    }

    @Test
    public void testAuditAllowed() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        this.setupAuditLogs();
        FSDataInputStream istream = userfs.open(file);
        int val = istream.read();
        istream.close();
        this.verifyAuditLogs(true);
        Assert.assertTrue((String)"failed to read from file", (val >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAuditAllowedStat() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        this.setupAuditLogs();
        FileStatus st = userfs.getFileStatus(file);
        this.verifyAuditLogs(true);
        Assert.assertTrue((String)"failed to stat file", (st != null && st.isFile() ? 1 : 0) != 0);
    }

    @Test
    public void testAuditDenied() throws Exception {
        Path file = new Path(this.fnames[0]);
        FileSystem userfs = DFSTestUtil.getFileSystemAs(this.userGroupInfo, this.conf);
        this.fs.setPermission(file, new FsPermission(384));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        try {
            userfs.open(file);
            Assert.fail((String)"open must not succeed");
        }
        catch (AccessControlException e) {
            System.out.println("got access denied, as expected.");
        }
        this.verifyAuditLogs(false);
    }

    @Test
    public void testAuditWebHdfs() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf);
        FSDataInputStream istream = webfs.open(file);
        int val = istream.read();
        istream.close();
        this.verifyAuditLogsRepeat(true, 3);
        Assert.assertTrue((String)"failed to read from file", (val >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAuditWebHdfsStat() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(420));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf);
        FileStatus st = webfs.getFileStatus(file);
        this.verifyAuditLogs(true);
        Assert.assertTrue((String)"failed to stat file", (st != null && st.isFile() ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAuditHftp() throws Exception {
        Path file = new Path(this.fnames[0]);
        String hftpUri = "hftp://" + this.conf.get("dfs.namenode.http-address");
        HftpFileSystem hftpFs = null;
        this.setupAuditLogs();
        try {
            hftpFs = (HftpFileSystem)new Path(hftpUri).getFileSystem(this.conf);
            FSDataInputStream istream = hftpFs.open(file);
            int val = istream.read();
            istream.close();
            this.verifyAuditLogs(true);
        }
        finally {
            if (hftpFs != null) {
                hftpFs.close();
            }
        }
    }

    @Test
    public void testAuditWebHdfsDenied() throws Exception {
        Path file = new Path(this.fnames[0]);
        this.fs.setPermission(file, new FsPermission(384));
        this.fs.setOwner(file, "root", null);
        this.setupAuditLogs();
        try {
            WebHdfsFileSystem webfs = WebHdfsTestUtil.getWebHdfsFileSystemAs(this.userGroupInfo, this.conf);
            FSDataInputStream istream = webfs.open(file);
            int val = istream.read();
            Assert.fail((String)("open+read must not succeed, got " + val));
        }
        catch (AccessControlException E) {
            System.out.println("got access denied, as expected.");
        }
        this.verifyAuditLogsRepeat(false, 2);
    }

    private void setupAuditLogs() throws IOException {
        LogManager.shutdown();
        File file = new File(auditLogFile);
        if (file.exists()) {
            Assert.assertTrue((boolean)file.delete());
        }
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.INFO);
        PatternLayout layout = new PatternLayout("%m%n");
        RollingFileAppender appender = new RollingFileAppender((Layout)layout, auditLogFile);
        logger.addAppender((Appender)appender);
    }

    private void verifyAuditLogs(boolean expectSuccess) throws IOException {
        this.verifyAuditLogsRepeat(expectSuccess, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyAuditLogsRepeat(boolean expectSuccess, int ndupe) throws IOException {
        Logger logger = ((Log4JLogger)FSNamesystem.auditLog).getLogger();
        logger.setLevel(Level.OFF);
        BufferedReader reader = new BufferedReader(new FileReader(auditLogFile));
        String line = null;
        boolean ret = true;
        try {
            for (int i = 0; i < ndupe; ++i) {
                line = reader.readLine();
                Assert.assertNotNull((Object)line);
                Assert.assertTrue((String)"Expected audit event not found in audit log", (boolean)auditPattern.matcher(line).matches());
                ret &= successPattern.matcher(line).matches();
            }
            Assert.assertNull((String)"Unexpected event in audit log", (Object)reader.readLine());
            Assert.assertTrue((String)("Expected success=" + expectSuccess), (ret == expectSuccess ? 1 : 0) != 0);
        }
        finally {
            reader.close();
        }
    }
}

