/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.ArrayFile;
import org.apache.hadoop.io.MapFile;
import org.apache.hadoop.io.RandomDatum;
import org.apache.hadoop.io.Writable;

public class TestArrayFile
extends TestCase {
    private static final Log LOG = LogFactory.getLog(TestArrayFile.class);
    private static String FILE = System.getProperty("test.build.data", ".") + "/test.array";

    public TestArrayFile(String name) {
        super(name);
    }

    public void testArrayFile() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        RandomDatum[] data = TestArrayFile.generate(10000);
        TestArrayFile.writeTest((FileSystem)fs, data, FILE);
        TestArrayFile.readTest((FileSystem)fs, data, FILE, conf);
    }

    public void testEmptyFile() throws Exception {
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        TestArrayFile.writeTest((FileSystem)fs, new RandomDatum[0], FILE);
        ArrayFile.Reader reader = new ArrayFile.Reader((FileSystem)fs, FILE, conf);
        TestArrayFile.assertNull((Object)reader.get(0L, (Writable)new RandomDatum()));
        reader.close();
    }

    private static RandomDatum[] generate(int count) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("generating " + count + " records in debug"));
        }
        RandomDatum[] data = new RandomDatum[count];
        RandomDatum.Generator generator = new RandomDatum.Generator();
        for (int i = 0; i < count; ++i) {
            generator.next();
            data[i] = generator.getValue();
        }
        return data;
    }

    private static void writeTest(FileSystem fs, RandomDatum[] data, String file) throws IOException {
        Configuration conf = new Configuration();
        MapFile.delete((FileSystem)fs, (String)file);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("creating with " + data.length + " debug"));
        }
        ArrayFile.Writer writer = new ArrayFile.Writer(conf, fs, file, RandomDatum.class);
        writer.setIndexInterval(100);
        for (int i = 0; i < data.length; ++i) {
            writer.append((Writable)data[i]);
        }
        writer.close();
    }

    private static void readTest(FileSystem fs, RandomDatum[] data, String file, Configuration conf) throws IOException {
        int i;
        RandomDatum v = new RandomDatum();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("reading " + data.length + " debug"));
        }
        ArrayFile.Reader reader = new ArrayFile.Reader(fs, file, conf);
        for (i = 0; i < data.length; ++i) {
            reader.get((long)i, (Writable)v);
            if (v.equals(data[i])) continue;
            throw new RuntimeException("wrong value at " + i);
        }
        for (i = data.length - 1; i >= 0; --i) {
            reader.get((long)i, (Writable)v);
            if (v.equals(data[i])) continue;
            throw new RuntimeException("wrong value at " + i);
        }
        reader.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("done reading " + data.length + " debug"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int count = 0x100000;
        boolean create = true;
        boolean check = true;
        String file = FILE;
        String usage = "Usage: TestArrayFile [-count N] [-nocreate] [-nocheck] file";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(-1);
        }
        Configuration conf = new Configuration();
        Path fpath = null;
        FileSystem fs = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                if (args[i].equals("-count")) {
                    count = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-nocreate")) {
                    create = false;
                    continue;
                }
                if (args[i].equals("-nocheck")) {
                    check = false;
                    continue;
                }
                file = args[i];
                fpath = new Path(file);
            }
            fs = fpath.getFileSystem(conf);
            LOG.info((Object)("count = " + count));
            LOG.info((Object)("create = " + create));
            LOG.info((Object)("check = " + check));
            LOG.info((Object)("file = " + file));
            RandomDatum[] data = TestArrayFile.generate(count);
            if (create) {
                TestArrayFile.writeTest(fs, data, file);
            }
            if (check) {
                TestArrayFile.readTest(fs, data, file, conf);
            }
        }
        finally {
            fs.close();
        }
    }
}

