/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.tags.annotation;

import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.tags.JavaField;
import org.apache.felix.scrplugin.tags.JavaTag;
import org.apache.felix.scrplugin.tags.annotation.AnnotationJavaClassDescription;
import org.apache.felix.scrplugin.tags.annotation.AnnotationTagProvider;
import org.apache.felix.scrplugin.tags.annotation.defaulttag.DefaultAnnotationTagProvider;
import org.apache.felix.scrplugin.tags.annotation.sling.SlingAnnotationTagProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationTagProviderManager {
    private final List<AnnotationTagProvider> annotationTagProviders = new ArrayList<AnnotationTagProvider>();

    public AnnotationTagProviderManager(String[] annotationTagProviderClasses) throws SCRDescriptorFailureException {
        this.annotationTagProviders.add(new DefaultAnnotationTagProvider());
        this.annotationTagProviders.add(new SlingAnnotationTagProvider());
        for (int i = 0; i < annotationTagProviderClasses.length; ++i) {
            try {
                Class<?> clazz = Class.forName(annotationTagProviderClasses[i]);
                try {
                    this.annotationTagProviders.add((AnnotationTagProvider)clazz.newInstance());
                    continue;
                }
                catch (ClassCastException e) {
                    throw new SCRDescriptorFailureException("Class '" + clazz.getName() + "' " + "does not implement interface '" + AnnotationTagProvider.class.getName() + "'.");
                }
                catch (InstantiationException e) {
                    throw new SCRDescriptorFailureException("Unable to instantiate class '" + clazz.getName() + "': " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new SCRDescriptorFailureException("Illegal access to class '" + clazz.getName() + "': " + e.getMessage());
                }
            }
            catch (ClassNotFoundException ex) {
                throw new SCRDescriptorFailureException("Annotation provider class '" + annotationTagProviderClasses[i] + "' not found.");
            }
        }
    }

    public List<JavaTag> getTags(Annotation annotation, AnnotationJavaClassDescription description) {
        return this.getTags(annotation, description, null);
    }

    public List<JavaTag> getTags(Annotation annotation, AnnotationJavaClassDescription description, JavaField field) {
        ArrayList<JavaTag> tags = new ArrayList<JavaTag>();
        for (AnnotationTagProvider provider : this.annotationTagProviders) {
            tags.addAll(provider.getTags(annotation, description, field));
        }
        return tags;
    }

    public boolean hasScrPluginAnnotation(JavaClass pClass) {
        for (Annotation annotation : pClass.getAnnotations()) {
            if (this.getTags(annotation, null).size() <= 0) continue;
            return true;
        }
        return false;
    }
}

