/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import java.util.HashMap;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.Control;
import org.apache.directory.shared.ldap.codec.ControlDecoder;
import org.apache.directory.shared.ldap.codec.LdapMessage;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.ManageDsaITControlDecoder;
import org.apache.directory.shared.ldap.codec.search.controls.PSearchControlDecoder;
import org.apache.directory.shared.ldap.codec.search.controls.SubEntryControlDecoder;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControlValueAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger((Class)ControlValueAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private static Map controlDecoders = new HashMap();

    public ControlValueAction() {
        super("Sets the control value");
        ControlDecoder decoder = new PSearchControlDecoder();
        controlDecoders.put(decoder.getControlType(), decoder);
        decoder = new ManageDsaITControlDecoder();
        controlDecoders.put(decoder.getControlType(), decoder);
        decoder = new SubEntryControlDecoder();
        controlDecoders.put(decoder.getControlType(), decoder);
    }

    public void action(IAsn1Container container) throws DecoderException, NamingException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        LdapMessage message = ldapMessageContainer.getLdapMessage();
        Control control = message.getCurrentControl();
        Value value = tlv.getValue();
        ControlDecoder decoder = (ControlDecoder)controlDecoders.get(control.getControlType());
        if (tlv.getLength() == 0) {
            control.setControlValue(new byte[0]);
        } else {
            Object decoded = decoder != null ? (Object)decoder.decode(value.getData()) : value.getData();
            control.setEncodedValue(value.getData());
            control.setControlValue(decoded);
        }
        ldapMessageContainer.grammarEndAllowed(true);
        if (IS_DEBUG) {
            if (control.getControlValue() instanceof byte[]) {
                log.debug("Control value : " + StringTools.dumpBytes((byte[])control.getControlValue()));
            } else if (control.getControlValue() instanceof String) {
                log.debug("Control value : " + (String)control.getControlValue());
            } else {
                log.debug("Control value : " + control.getControlValue());
            }
        }
    }
}

