/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.loader.ldif;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.ResourceMap;
import org.apache.directory.shared.ldap.schema.registries.AbstractSchemaLoader;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarLdifSchemaLoader
extends AbstractSchemaLoader {
    private static final String LDIF_EXT = "ldif";
    private static final Logger LOG = LoggerFactory.getLogger(JarLdifSchemaLoader.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final Map<String, Boolean> RESOURCE_MAP = ResourceMap.getResources((Pattern)Pattern.compile(".*schema/ou=schema.*"));

    public JarLdifSchemaLoader() throws Exception {
        this.initializeSchemas();
    }

    private final URL getResource(String resource, String msg) throws Exception {
        if (RESOURCE_MAP.get(resource).booleanValue()) {
            return DefaultSchemaLdifExtractor.getUniqueResource((String)resource, (String)msg);
        }
        return new File(resource).toURI().toURL();
    }

    private void initializeSchemas() throws Exception {
        if (IS_DEBUG) {
            LOG.debug("Initializing schema");
        }
        for (String file : RESOURCE_MAP.keySet()) {
            Pattern pat = Pattern.compile(".*schema/ou=schema/cn=[a-z0-9-_]*\\.ldif");
            if (!pat.matcher(file).matches()) continue;
            URL resource = this.getResource(file, "schema LDIF file");
            InputStream in = resource.openStream();
            try {
                LdifReader reader = new LdifReader(in);
                LdifEntry entry = reader.next();
                reader.close();
                Schema schema = this.getSchema(entry.getEntry());
                this.schemaMap.put(schema.getSchemaName(), schema);
                if (!IS_DEBUG) continue;
                LOG.debug("Schema Initialized ... \n{}", (Object)schema);
            }
            catch (Exception e) {
                LOG.error(I18n.err((String)"ERR_10003", (Object[])new Object[]{file}), (Throwable)e);
                throw e;
            }
            finally {
                in.close();
            }
        }
    }

    private final String getSchemaDirectory(Schema schema) {
        return "schema/ou=schema/cn=" + schema.getSchemaName();
    }

    public List<Entry> loadComparators(Schema ... schemas) throws Exception {
        ArrayList<Entry> comparatorList = new ArrayList<Entry>();
        if (schemas == null) {
            return comparatorList;
        }
        for (Schema schema : schemas) {
            String comparatorsDirectory = this.getSchemaDirectory(schema) + "/" + "ou=comparators";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + comparatorsDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "comparator LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                comparatorList.add(entry.getEntry());
            }
        }
        return comparatorList;
    }

    public List<Entry> loadSyntaxCheckers(Schema ... schemas) throws Exception {
        ArrayList<Entry> syntaxCheckerList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxCheckerList;
        }
        for (Schema schema : schemas) {
            String syntaxCheckersDirectory = this.getSchemaDirectory(schema) + "/" + "ou=syntaxcheckers";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + syntaxCheckersDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "syntaxChecker LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                syntaxCheckerList.add(entry.getEntry());
            }
        }
        return syntaxCheckerList;
    }

    public List<Entry> loadNormalizers(Schema ... schemas) throws Exception {
        ArrayList<Entry> normalizerList = new ArrayList<Entry>();
        if (schemas == null) {
            return normalizerList;
        }
        for (Schema schema : schemas) {
            String normalizersDirectory = this.getSchemaDirectory(schema) + "/" + "ou=normalizers";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + normalizersDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "normalizer LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                normalizerList.add(entry.getEntry());
            }
        }
        return normalizerList;
    }

    public List<Entry> loadMatchingRules(Schema ... schemas) throws Exception {
        ArrayList<Entry> matchingRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleList;
        }
        for (Schema schema : schemas) {
            String matchingRulesDirectory = this.getSchemaDirectory(schema) + "/" + "ou=matchingrules";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + matchingRulesDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "matchingRules LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                matchingRuleList.add(entry.getEntry());
            }
        }
        return matchingRuleList;
    }

    public List<Entry> loadSyntaxes(Schema ... schemas) throws Exception {
        ArrayList<Entry> syntaxList = new ArrayList<Entry>();
        if (schemas == null) {
            return syntaxList;
        }
        for (Schema schema : schemas) {
            String syntaxesDirectory = this.getSchemaDirectory(schema) + "/" + "ou=syntaxes";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + syntaxesDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "syntax LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                syntaxList.add(entry.getEntry());
            }
        }
        return syntaxList;
    }

    public List<Entry> loadAttributeTypes(Schema ... schemas) throws Exception {
        ArrayList<Entry> attributeTypeList = new ArrayList<Entry>();
        if (schemas == null) {
            return attributeTypeList;
        }
        for (Schema schema : schemas) {
            String attributeTypesDirectory = this.getSchemaDirectory(schema) + "/" + "ou=attributetypes";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + attributeTypesDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "attributeType LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                attributeTypeList.add(entry.getEntry());
            }
        }
        return attributeTypeList;
    }

    public List<Entry> loadMatchingRuleUses(Schema ... schemas) throws Exception {
        ArrayList<Entry> matchingRuleUseList = new ArrayList<Entry>();
        if (schemas == null) {
            return matchingRuleUseList;
        }
        for (Schema schema : schemas) {
            String matchingRuleUsesDirectory = this.getSchemaDirectory(schema) + "/" + "ou=matchingruleuse";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + matchingRuleUsesDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "matchingRuleUse LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                matchingRuleUseList.add(entry.getEntry());
            }
        }
        return matchingRuleUseList;
    }

    public List<Entry> loadNameForms(Schema ... schemas) throws Exception {
        ArrayList<Entry> nameFormList = new ArrayList<Entry>();
        if (schemas == null) {
            return nameFormList;
        }
        for (Schema schema : schemas) {
            String nameFormsDirectory = this.getSchemaDirectory(schema) + "/" + "ou=nameforms";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + nameFormsDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "nameForm LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                nameFormList.add(entry.getEntry());
            }
        }
        return nameFormList;
    }

    public List<Entry> loadDitContentRules(Schema ... schemas) throws Exception {
        ArrayList<Entry> ditContentRulesList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditContentRulesList;
        }
        for (Schema schema : schemas) {
            String ditContentRulesDirectory = this.getSchemaDirectory(schema) + "/" + "ou=ditcontentrules";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + ditContentRulesDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "ditContentRule LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                ditContentRulesList.add(entry.getEntry());
            }
        }
        return ditContentRulesList;
    }

    public List<Entry> loadDitStructureRules(Schema ... schemas) throws Exception {
        ArrayList<Entry> ditStructureRuleList = new ArrayList<Entry>();
        if (schemas == null) {
            return ditStructureRuleList;
        }
        for (Schema schema : schemas) {
            String ditStructureRulesDirectory = this.getSchemaDirectory(schema) + "/" + "ou=ditstructurerules";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + ditStructureRulesDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "ditStructureRule LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                ditStructureRuleList.add(entry.getEntry());
            }
        }
        return ditStructureRuleList;
    }

    public List<Entry> loadObjectClasses(Schema ... schemas) throws Exception {
        ArrayList<Entry> objectClassList = new ArrayList<Entry>();
        if (schemas == null) {
            return objectClassList;
        }
        for (Schema schema : schemas) {
            String objectClassesDirectory = this.getSchemaDirectory(schema) + "/" + "ou=objectclasses";
            for (String resourcePath : RESOURCE_MAP.keySet()) {
                Pattern regex = Pattern.compile(".*" + objectClassesDirectory + "/m-oid=.*\\." + LDIF_EXT);
                if (!regex.matcher(resourcePath).matches()) continue;
                URL resource = this.getResource(resourcePath, "objectClass LDIF file");
                LdifReader reader = new LdifReader(resource.openStream());
                LdifEntry entry = reader.next();
                reader.close();
                objectClassList.add(entry.getEntry());
            }
        }
        return objectClassList;
    }
}

