/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.support;

import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.ldap.SessionRegistry;
import org.apache.directory.server.ldap.support.LdapMessageHandler;
import org.apache.directory.shared.ldap.message.AbandonRequest;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.apache.directory.shared.ldap.message.Request;
import org.apache.mina.common.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbandonHandler
implements LdapMessageHandler {
    private static final Logger log = LoggerFactory.getLogger((Class)AbandonHandler.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public void messageReceived(IoSession session, Object request) {
        AbandonRequest req = (AbandonRequest)request;
        int abandonedId = req.getAbandoned();
        if (abandonedId < 0) {
            return;
        }
        Request abandonedRequest = SessionRegistry.getSingleton().getOutstandingRequest(session, abandonedId);
        if (abandonedRequest == null) {
            if (log.isWarnEnabled()) {
                log.warn("Got abandon request from client " + session + " but request must have already " + "terminated.  Abandon request " + req + " had no effect.");
            }
            return;
        }
        if (abandonedRequest instanceof AbandonableRequest) {
            log.warn("Abandon, Bind, Unbind, and StartTLS operations cannot be abandoned.  Abandon request will be ignored.");
        }
        ((AbandonableRequest)abandonedRequest).abandon();
        if (SessionRegistry.getSingleton().removeOutstandingRequest(session, abandonedId) == null) {
            if (log.isWarnEnabled()) {
                log.warn("Got abandon request from client " + session + " but request must have already " + "terminated.");
            }
        } else if (IS_DEBUG) {
            log.debug("Abandoned request: " + req);
        }
    }

    public void init(StartupConfiguration cfg) {
    }
}

