/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PrincipalNameType
implements Comparable<PrincipalNameType> {
    public static final PrincipalNameType KRB_NT_UNKNOWN = new PrincipalNameType(0, "Name type not known.");
    public static final PrincipalNameType KRB_NT_PRINCIPAL = new PrincipalNameType(1, "Just the name of the principal as in DCE, or for users.");
    public static final PrincipalNameType KRB_NT_SRV_INST = new PrincipalNameType(2, "Service and other unique instance (krbtgt).");
    public static final PrincipalNameType KRB_NT_SRV_HST = new PrincipalNameType(3, "Service with host name as instance (telnet, rcommands).");
    public static final PrincipalNameType KRB_NT_SRV_XHST = new PrincipalNameType(4, "Service with host as remaining components.");
    public static final PrincipalNameType KRB_NT_UID = new PrincipalNameType(5, "Unique ID.");
    public static final PrincipalNameType KRB_NT_X500_PRINCIPAL = new PrincipalNameType(6, "Encoded X.509 Distinguished name [RFC2253].");
    public static final PrincipalNameType KRB_NT_SMTP_NAME = new PrincipalNameType(7, "Name in form of SMTP email name (e.g., user@example.com).");
    public static final PrincipalNameType KRB_NT_ENTERPRISE = new PrincipalNameType(10, "Enterprise name; may be mapped to principal name.");
    private static final PrincipalNameType[] values = new PrincipalNameType[]{KRB_NT_UNKNOWN, KRB_NT_PRINCIPAL, KRB_NT_SRV_INST, KRB_NT_SRV_HST, KRB_NT_SRV_XHST, KRB_NT_UID, KRB_NT_X500_PRINCIPAL, KRB_NT_SMTP_NAME, KRB_NT_ENTERPRISE};
    public static final List<PrincipalNameType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private PrincipalNameType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static PrincipalNameType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (PrincipalNameType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return KRB_NT_UNKNOWN;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(PrincipalNameType that) {
        return this.ordinal - that.ordinal;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }
}

