/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.AbstractHTTPDestination;

public final class HttpUtils {
    private static final String LOCAL_IP_ADDRESS = "127.0.0.1";
    private static final String LOCAL_HOST = "localhost";
    private static final Pattern ENCODE_PATTERN = Pattern.compile("%[0-9a-fA-F][0-9a-fA-F]");

    private HttpUtils() {
    }

    public static String urlDecode(String value) {
        return UrlUtils.urlDecode((String)value);
    }

    public static String pathDecode(String value) {
        return UrlUtils.pathDecode((String)value);
    }

    public static String urlEncode(String value) {
        try {
            value = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return value;
    }

    public static String pathEncode(String value) {
        String result = HttpUtils.urlEncode(value);
        if (result.indexOf(43) != -1) {
            result = result.replace("+", "%20");
        }
        if (result.indexOf("%2B") != -1) {
            result = result.replace("%2B", "+");
        }
        return result;
    }

    public static String encodePartiallyEncoded(String encoded, boolean query) {
        if (encoded.length() == 0) {
            return encoded;
        }
        Matcher m = ENCODE_PATTERN.matcher(encoded);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (m.find()) {
            String before = encoded.substring(i, m.start());
            sb.append(query ? HttpUtils.urlEncode(before) : HttpUtils.pathEncode(before));
            sb.append(m.group());
            i = m.end();
        }
        String tail = encoded.substring(i, encoded.length());
        sb.append(query ? HttpUtils.urlEncode(tail) : HttpUtils.pathEncode(tail));
        return sb.toString();
    }

    public static SimpleDateFormat getHttpDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        TimeZone tZone = TimeZone.getTimeZone("GMT");
        dateFormat.setTimeZone(tZone);
        return dateFormat;
    }

    public static boolean isDateRelatedHeader(String headerName) {
        return "Date".equalsIgnoreCase(headerName) || "If-Modified-Since".equalsIgnoreCase(headerName) || "If-Unmodified-Since".equalsIgnoreCase(headerName) || "Expires".equalsIgnoreCase(headerName) || "Last-Modified".equalsIgnoreCase(headerName);
    }

    public static URI toAbsoluteUri(URI u, Message message) {
        HttpServletRequest httpRequest;
        if (!u.isAbsolute() && (httpRequest = (HttpServletRequest)message.get((Object)"HTTP.REQUEST")) != null) {
            String scheme = httpRequest.isSecure() ? "https" : "http";
            String host = httpRequest.getLocalName();
            if (LOCAL_IP_ADDRESS.equals(host)) {
                host = LOCAL_HOST;
            }
            int port = httpRequest.getLocalPort();
            return URI.create(scheme + "://" + host + ':' + port + u.toString());
        }
        return u;
    }

    public static String getPathToMatch(Message m, boolean addSlash) {
        String requestAddress = HttpUtils.getProtocolHeader(m, "org.apache.cxf.request.uri", "/");
        String baseAddress = HttpUtils.getBaseAddress(m);
        return HttpUtils.getPathToMatch(requestAddress, baseAddress, addSlash);
    }

    public static String getProtocolHeader(Message m, String name, String defaultValue) {
        String value = (String)m.get((Object)name);
        if (value == null) {
            value = (String)new HttpHeadersImpl(m).getRequestHeaders().getFirst((Object)name);
        }
        return value == null ? defaultValue : value;
    }

    public static String getBaseAddress(Message m) {
        String endpointAddress = HttpUtils.getEndpointAddress(m);
        try {
            return new URL(endpointAddress).getPath();
        }
        catch (MalformedURLException ex) {
            return endpointAddress == null ? "/" : endpointAddress;
        }
    }

    public static String getEndpointAddress(Message m) {
        String address = null;
        Destination d = m.getExchange().getDestination();
        address = d != null ? (d instanceof AbstractHTTPDestination ? ((AbstractHTTPDestination)d).getEndpointInfo().getAddress() : d.getAddress().getAddress().getValue()) : (String)m.get((Object)Message.ENDPOINT_ADDRESS);
        return address;
    }

    public static void updatePath(Message m, String path) {
        String baseAddress = HttpUtils.getBaseAddress(m);
        boolean pathSlash = path.startsWith("/");
        boolean baseSlash = baseAddress.endsWith("/");
        if (pathSlash && baseSlash) {
            path = path.substring(1);
        } else if (!pathSlash && !baseSlash) {
            path = "/" + path;
        }
        m.put((Object)"org.apache.cxf.request.uri", (Object)(baseAddress + path));
    }

    public static String getPathToMatch(String path, String address, boolean addSlash) {
        int ind = path.indexOf(address);
        if (ind == -1 && address.equals(path + "/")) {
            path = path + "/";
            ind = 0;
        }
        if (ind == 0) {
            path = path.substring(ind + address.length());
        }
        if (addSlash && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public static String getOriginalAddress(Message m) {
        Destination d = m.getDestination();
        return d == null ? "/" : d.getAddress().getAddress().getValue();
    }

    public static String fromPathSegment(PathSegment ps) {
        if (PathSegmentImpl.class.isAssignableFrom(ps.getClass())) {
            return ((PathSegmentImpl)ps).getOriginalPath();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ps.getPath());
        for (Map.Entry entry : ps.getMatrixParameters().entrySet()) {
            for (String value : (List)entry.getValue()) {
                sb.append(';').append((String)entry.getKey());
                if (value == null) continue;
                sb.append('=').append(value);
            }
        }
        return sb.toString();
    }

    public static Response.Status getParameterFailureStatus(ParameterType pType) {
        if (pType == ParameterType.MATRIX || pType == ParameterType.PATH || pType == ParameterType.QUERY) {
            return Response.Status.NOT_FOUND;
        }
        return Response.Status.BAD_REQUEST;
    }
}

