/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.java2wsdl.JavaToWSDL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.ExitException;
import org.apache.tools.ant.util.optional.NoExitSecurityManager;

public class Java2WSDLMojo
extends AbstractMojo {
    String className;
    String classpath;
    String outputFile;
    Boolean soap12;
    String targetNamespace;
    String serviceName;
    Boolean verbose;
    Boolean quiet;
    List classpathElements;
    MavenProject project;
    String argline;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        File classesDir = new File(this.classpath);
        FileUtils.mkDir((File)classesDir);
        StringBuffer buf = new StringBuffer();
        for (Object classpathElement : this.classpathElements) {
            buf.append(classpathElement.toString());
            buf.append(File.pathSeparatorChar);
        }
        String newCp = buf.toString();
        String cp = System.getProperty("java.class.path");
        SecurityManager oldSm = System.getSecurityManager();
        try {
            System.setProperty("java.class.path", newCp);
            System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
            this.processJavaClass();
        }
        finally {
            System.setSecurityManager(oldSm);
            System.setProperty("java.class.path", cp);
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJavaClass() throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        if (this.outputFile == null && this.project != null) {
            int i = this.className.lastIndexOf(46);
            String name = this.className.substring(i + 1);
            this.outputFile = (this.project.getBuild().getDirectory() + "/generated/wsdl/" + name + ".wsdl").replace("/", File.separator);
        }
        if (this.outputFile != null) {
            FileUtils.mkDir((File)new File(this.outputFile).getParentFile());
            args.add("-o");
            args.add(this.outputFile);
            if (this.project != null) {
                this.project.addCompileSourceRoot(new File(this.outputFile).getParentFile().getAbsolutePath());
            }
        }
        args.add("-cp");
        args.add(this.classpath);
        if (this.soap12 != null && this.soap12.booleanValue()) {
            args.add("-soap12");
        }
        if (this.targetNamespace != null) {
            args.add("-t");
            args.add(this.targetNamespace);
        }
        if (this.serviceName != null) {
            args.add("-servicename");
            args.add(this.serviceName);
        }
        if (this.verbose != null && this.verbose.booleanValue()) {
            args.add("-verbose");
        }
        if (this.quiet != null && this.quiet.booleanValue()) {
            args.add("-quiet");
        }
        if (this.argline != null) {
            StringTokenizer stoken = new StringTokenizer(this.argline, " ");
            while (stoken.hasMoreTokens()) {
                args.add(stoken.nextToken());
            }
        }
        args.add(this.className);
        try {
            String exitOnFinish = System.getProperty("exitOnFinish", "");
            try {
                System.setProperty("exitOnFinish", "YES");
                JavaToWSDL.main((String[])args.toArray(new String[args.size()]));
            }
            catch (ExitException e) {
                if (e.getStatus() != 0) {
                    throw e;
                }
            }
            finally {
                System.setProperty("exitOnFinish", exitOnFinish);
            }
        }
        catch (Throwable e) {
            this.getLog().debug(e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

