/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils.schemas;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(SchemaHandler.class);
    private Schema schema;
    private Bus bus;

    public void setBus(Bus b) {
        this.bus = b;
    }

    public void setSchemas(List<String> locations) {
        this.schema = SchemaHandler.createSchema(locations, this.bus == null ? BusFactory.getThreadDefaultBus() : this.bus);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public static Schema createSchema(List<String> locations, Bus bus) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema s = null;
        try {
            ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
            for (String loc : locations) {
                URL url = ResourceUtils.getResourceURL(loc, bus);
                if (url == null) {
                    return null;
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                StreamSource source = new StreamSource(r);
                source.setSystemId(url.toString());
                sources.add(source);
            }
            s = factory.newSchema(sources.toArray(new Source[0]));
        }
        catch (Exception ex) {
            LOG.warning("Validation will be disabled, failed to create schema : " + ex.getMessage());
        }
        return s;
    }
}

