/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.ws.rs.core.Context;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResourceInfo {
    private static Map<Class<?>, List<Field>> contextFields;
    private static Map<Class<?>, List<Field>> resourceFields;
    private static Map<Class<?>, Map<Class<?>, Method>> contextMethods;
    private static Map<Class<?>, Map<Field, ThreadLocalProxy>> fieldProxyMap;
    private static Map<Class<?>, Map<Field, ThreadLocalProxy>> resourceProxyMap;
    private static Map<Class<?>, Map<Method, ThreadLocalProxy>> setterProxyMap;
    protected boolean root;
    protected Class<?> resourceClass;
    protected Class<?> serviceClass;

    protected AbstractResourceInfo() {
    }

    protected AbstractResourceInfo(Class<?> resourceClass, Class<?> serviceClass, boolean isRoot) {
        this.serviceClass = serviceClass;
        this.resourceClass = resourceClass;
        this.root = isRoot;
        if (this.root && resourceClass != null) {
            this.findContextFields(serviceClass);
            this.findContextSetterMethods(serviceClass);
        }
    }

    public void setResourceClass(Class<?> rClass) {
        this.resourceClass = rClass;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    private void findContextFields(Class<?> cls) {
        if (cls == Object.class || cls == null) {
            return;
        }
        for (Field f : cls.getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                if (a.annotationType() == Context.class) {
                    if (contextFields == null) {
                        contextFields = new HashMap();
                    }
                    this.addContextField(contextFields, f);
                    if (fieldProxyMap == null) {
                        fieldProxyMap = new HashMap();
                    }
                    this.addToMap(fieldProxyMap, f, InjectionUtils.createThreadLocalProxy(f.getType()));
                    continue;
                }
                if (a.annotationType() != Resource.class || !AnnotationUtils.isContextClass(f.getType())) continue;
                if (resourceFields == null) {
                    resourceFields = new HashMap();
                }
                this.addContextField(resourceFields, f);
                if (resourceProxyMap == null) {
                    resourceProxyMap = new HashMap();
                }
                this.addToMap(resourceProxyMap, f, InjectionUtils.createThreadLocalProxy(f.getType()));
            }
        }
        this.findContextFields(cls.getSuperclass());
    }

    private void findContextSetterMethods(Class<?> cls) {
        Class<?>[] interfaces;
        block0: for (Method m : cls.getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
            for (Annotation a : m.getAnnotations()) {
                if (a.annotationType() != Context.class) continue;
                this.checkContextMethod(m);
                continue block0;
            }
        }
        for (Class<?> i : interfaces = cls.getInterfaces()) {
            this.findContextSetterMethods(i);
        }
    }

    private void checkContextMethod(Method m) {
        Class<?> type = m.getParameterTypes()[0];
        if (AnnotationUtils.isContextClass(type) && m.getName().equals("set" + type.getSimpleName())) {
            this.addContextMethod(type, m);
        }
    }

    public Map<Class<?>, Method> getContextMethods() {
        Map<Class<?>, Method> methods = contextMethods == null ? null : contextMethods.get(this.getServiceClass());
        return methods == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(methods);
    }

    private void addContextMethod(Class<?> contextClass, Method m) {
        if (contextMethods == null) {
            contextMethods = new HashMap();
        }
        this.addToMap(contextMethods, contextClass, m);
        if (setterProxyMap == null) {
            setterProxyMap = new HashMap();
        }
        this.addToMap(setterProxyMap, m, InjectionUtils.createThreadLocalProxy(m.getParameterTypes()[0]));
    }

    public boolean isRoot() {
        return this.root;
    }

    public Class<?> getResourceClass() {
        return this.resourceClass;
    }

    public List<Field> getContextFields() {
        return this.getList(contextFields);
    }

    public List<Field> getResourceFields() {
        return this.getList(resourceFields);
    }

    public ThreadLocalProxy getContextFieldProxy(Field f) {
        return this.getProxy(fieldProxyMap, f);
    }

    public ThreadLocalProxy getResourceFieldProxy(Field f) {
        return this.getProxy(resourceProxyMap, f);
    }

    public ThreadLocalProxy getContextSetterProxy(Method m) {
        return this.getProxy(setterProxyMap, m);
    }

    public abstract boolean isSingleton();

    public void clearThreadLocalProxies() {
        this.clearProxies(fieldProxyMap);
        this.clearProxies(resourceProxyMap);
        this.clearProxies(setterProxyMap);
    }

    private <T> void clearProxies(Map<Class<?>, Map<T, ThreadLocalProxy>> tlps) {
        Map<T, ThreadLocalProxy> proxies;
        Map<T, ThreadLocalProxy> map = proxies = tlps == null ? null : tlps.get(this.getServiceClass());
        if (proxies == null) {
            return;
        }
        for (ThreadLocalProxy tlp : proxies.values()) {
            if (tlp == null) continue;
            tlp.remove();
        }
    }

    private void addContextField(Map<Class<?>, List<Field>> theFields, Field f) {
        List<Field> fields = theFields.get(this.serviceClass);
        if (fields == null) {
            fields = new ArrayList<Field>();
            theFields.put(this.serviceClass, fields);
        }
        if (!fields.contains(f)) {
            fields.add(f);
        }
    }

    private <T, V> void addToMap(Map<Class<?>, Map<T, V>> theFields, T f, V proxy) {
        Map<T, V> proxies = theFields.get(this.serviceClass);
        if (proxies == null) {
            proxies = new HashMap<T, V>();
            theFields.put(this.serviceClass, proxies);
        }
        if (!proxies.containsKey(f)) {
            proxies.put(f, proxy);
        }
    }

    private List<Field> getList(Map<Class<?>, List<Field>> fields) {
        List<Field> ret = fields == null ? null : fields.get(this.getServiceClass());
        ret = ret != null ? Collections.unmodifiableList(ret) : Collections.emptyList();
        return ret;
    }

    private <T> ThreadLocalProxy getProxy(Map<Class<?>, Map<T, ThreadLocalProxy>> proxies, T key) {
        Map<T, ThreadLocalProxy> theMap = proxies == null ? null : proxies.get(this.getServiceClass());
        return theMap != null ? theMap.get(key) : null;
    }
}

