/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.util.function.BiFunction;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.exceptions.RequestFailureReason;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.FailureRecordingCallback;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PaxosRequestCallback<T>
extends FailureRecordingCallback<T> {
    private static final Logger logger = LoggerFactory.getLogger(PaxosRequestCallback.class);
    private static final boolean USE_SELF_EXECUTION = CassandraRelevantProperties.PAXOS_EXECUTE_ON_SELF.getBoolean();

    protected abstract void onResponse(T var1, InetAddressAndPort var2);

    @Override
    public void onResponse(Message<T> message) {
        this.onResponse(message.payload, message.from());
    }

    protected <I> void executeOnSelf(I parameter, BiFunction<I, InetAddressAndPort, T> execute) {
        T response;
        try {
            response = execute.apply(parameter, FBUtilities.getBroadcastAddressAndPort());
            if (response == null) {
                return;
            }
        }
        catch (Exception ex) {
            RequestFailureReason reason = RequestFailureReason.UNKNOWN;
            if (ex instanceof WriteTimeoutException) {
                reason = RequestFailureReason.TIMEOUT;
            } else {
                logger.error("Failed to apply {} locally", parameter, (Object)ex);
            }
            this.onFailure(FBUtilities.getBroadcastAddressAndPort(), reason);
            return;
        }
        this.onResponse(response, FBUtilities.getBroadcastAddressAndPort());
    }

    static boolean shouldExecuteOnSelf(InetAddressAndPort replica) {
        return USE_SELF_EXECUTION && replica.equals(FBUtilities.getBroadcastAddressAndPort());
    }
}

