/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectionType<T>
extends AbstractType<T> {
    private static final Logger logger = LoggerFactory.getLogger(CollectionType.class);
    public static final int MAX_ELEMENTS = 65535;
    public final Kind kind;

    protected CollectionType(Kind kind) {
        this.kind = kind;
    }

    public abstract AbstractType<?> nameComparator();

    public abstract AbstractType<?> valueComparator();

    protected abstract void appendToStringBuilder(StringBuilder var1);

    public abstract List<ByteBuffer> serializedValues(List<Cell> var1);

    @Override
    public abstract CollectionSerializer<T> getSerializer();

    @Override
    public void validateCellValue(ByteBuffer cellValue) throws MarshalException {
        this.valueComparator().validate(cellValue);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendToStringBuilder(sb);
        return sb.toString();
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return BytesType.instance.getString(bytes);
    }

    @Override
    public ByteBuffer fromString(String source) {
        try {
            return ByteBufferUtil.hexToBytes(source);
        }
        catch (NumberFormatException e) {
            throw new MarshalException(String.format("cannot parse '%s' as hex bytes", source), e);
        }
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!this.getClass().equals(previous.getClass())) {
            return false;
        }
        CollectionType tprev = (CollectionType)previous;
        return this.nameComparator().isCompatibleWith(tprev.nameComparator()) && this.valueComparator().isValueCompatibleWith(tprev.valueComparator());
    }

    @Override
    public boolean isCollection() {
        return true;
    }

    public boolean isMap() {
        return this.kind == Kind.MAP;
    }

    protected List<Cell> enforceLimit(List<Cell> cells, int version) {
        if (version >= 3 || cells.size() <= 65535) {
            return cells;
        }
        logger.error("Detected collection with {} elements, more than the {} limit. Only the first {} elements will be returned to the client. Please see http://cassandra.apache.org/doc/cql3/CQL.html#collections for more details.", new Object[]{cells.size(), 65535, 65535});
        return cells.subList(0, 65535);
    }

    public ByteBuffer serializeForNativeProtocol(List<Cell> cells, int version) {
        cells = this.enforceLimit(cells, version);
        List<ByteBuffer> values = this.serializedValues(cells);
        return CollectionSerializer.pack(values, cells.size(), version);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return new CQL3Type.Collection(this);
    }

    public static enum Kind {
        MAP,
        SET,
        LIST;

    }
}

