/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.cql3.statements.PropertyDefinitions;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;

public class KSPropDefs
extends PropertyDefinitions {
    public static final String KW_DURABLE_WRITES = "durable_writes";
    public static final String KW_REPLICATION = "replication";
    public static final String REPLICATION_STRATEGY_CLASS_KEY = "class";
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    private String strategyClass;

    public void validate() throws SyntaxException {
        if (this.strategyClass != null) {
            return;
        }
        this.validate(keywords, obsoleteKeywords);
        Map<String, String> replicationOptions = this.getReplicationOptions();
        if (!replicationOptions.isEmpty()) {
            this.strategyClass = replicationOptions.get(REPLICATION_STRATEGY_CLASS_KEY);
            replicationOptions.remove(REPLICATION_STRATEGY_CLASS_KEY);
        }
    }

    public Map<String, String> getReplicationOptions() throws SyntaxException {
        Map<String, String> replicationOptions = this.getMap(KW_REPLICATION);
        if (replicationOptions == null) {
            return Collections.emptyMap();
        }
        return replicationOptions;
    }

    public String getReplicationStrategyClass() {
        return this.strategyClass;
    }

    public KSMetaData asKSMetadata(String ksName) throws RequestValidationException {
        return KSMetaData.newKeyspace(ksName, this.getReplicationStrategyClass(), this.getReplicationOptions(), this.getBoolean(KW_DURABLE_WRITES, true));
    }

    public KSMetaData asKSMetadataUpdate(KSMetaData old) throws RequestValidationException {
        String sClass = this.strategyClass;
        Map<String, String> sOptions = this.getReplicationOptions();
        if (sClass == null) {
            sClass = old.strategyClass.getName();
            sOptions = old.strategyOptions;
        }
        return KSMetaData.newKeyspace(old.name, sClass, sOptions, this.getBoolean(KW_DURABLE_WRITES, old.durableWrites));
    }

    static {
        keywords.add(KW_DURABLE_WRITES);
        keywords.add(KW_REPLICATION);
    }
}

