/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.Collection;
import java.util.Collections;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.MigrationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationRequestVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(MigrationRequestVerbHandler.class);

    public void doVerb(MessageIn message, String id) {
        logger.debug("Received migration request from {}.", (Object)message.from);
        if (message.version < 6) {
            logger.debug("Returning empty response to the migration request from {} (version < 1.2).", (Object)message.from);
        }
        Collection<Object> schema = message.version < 6 ? Collections.EMPTY_SET : SystemTable.serializeSchema();
        MessageOut<Collection<RowMutation>> response = new MessageOut<Collection<RowMutation>>(MessagingService.Verb.INTERNAL_RESPONSE, schema, MigrationManager.MigrationsSerializer.instance);
        MessagingService.instance().sendReply(response, id, message.from);
    }
}

