/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.utils.SimpleCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateResponseHandler
implements IAsyncCallback {
    protected static final Logger logger = LoggerFactory.getLogger(TruncateResponseHandler.class);
    protected final SimpleCondition condition = new SimpleCondition();
    private final int responseCount;
    protected AtomicInteger responses = new AtomicInteger(0);
    private final long startTime;

    public TruncateResponseHandler(int responseCount) {
        assert (1 <= responseCount) : "invalid response count " + responseCount;
        this.responseCount = responseCount;
        this.startTime = System.currentTimeMillis();
    }

    public void get() throws TimeoutException {
        boolean success;
        long timeout = DatabaseDescriptor.getRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            throw new TimeoutException("Truncate timed out - received only " + this.responses.get() + " responses");
        }
    }

    @Override
    public void response(Message message) {
        this.responses.incrementAndGet();
        if (this.responses.get() >= this.responseCount) {
            this.condition.signal();
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

