/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataOutput;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;

public class EchoedRow
extends AbstractCompactedRow {
    private final SSTableIdentityIterator row;
    private final int gcBefore;

    public EchoedRow(CompactionController controller, SSTableIdentityIterator row) {
        super(row.getKey());
        this.row = row;
        this.gcBefore = controller.gcBefore;
        row.reset();
    }

    @Override
    public long write(DataOutput out) throws IOException {
        assert (this.row.dataSize > 0L);
        out.writeLong(this.row.dataSize);
        this.row.echoData(out);
        return this.row.dataSize;
    }

    @Override
    public void update(MessageDigest digest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return !this.row.hasNext() && ColumnFamilyStore.removeDeletedCF(this.row.getColumnFamily(), this.gcBefore) == null;
    }

    @Override
    public int columnCount() {
        return this.row.getColumnCount();
    }

    @Override
    public long maxTimestamp() {
        throw new UnsupportedOperationException();
    }
}

