/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.cql.jdbc.AbstractJdbcUUID;
import org.apache.cassandra.cql.jdbc.MarshalException;

public class JdbcUUID
extends AbstractJdbcUUID {
    public static final JdbcUUID instance = new JdbcUUID();

    JdbcUUID() {
    }

    @Override
    public UUID compose(ByteBuffer bytes) {
        if ((bytes = bytes.slice()).remaining() < 16) {
            return new UUID(0L, 0L);
        }
        return new UUID(bytes.getLong(), bytes.getLong());
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return "";
        }
        if (bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes");
        }
        return this.compose(bytes).toString();
    }
}

