/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.web.resources;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.CamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.view.RouteDotGenerator;
import org.apache.camel.web.resources.CamelChildResourceSupport;
import org.apache.camel.web.resources.CamelContextResource;
import org.apache.camel.web.resources.RouteResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoutesResource
extends CamelChildResourceSupport {
    public RoutesResource(CamelContextResource contextResource) {
        super(contextResource);
    }

    @GET
    @Produces(value={"text/xml", "application/xml", "application/json"})
    public RoutesDefinition getRouteDefinitions() {
        RoutesDefinition answer = new RoutesDefinition();
        CamelContext camelContext = this.getCamelContext();
        if (camelContext != null) {
            List list = camelContext.getRouteDefinitions();
            answer.setRoutes(list);
        }
        return answer;
    }

    @GET
    @Produces(value={"text/vnd.graphviz"})
    public String getDot() throws IOException {
        RouteDotGenerator generator = new RouteDotGenerator("/tmp/camel");
        return generator.getRoutesText(this.getCamelContext());
    }

    @Path(value="{id}")
    public RouteResource getRoute(@PathParam(value="id") String id) {
        List<RouteDefinition> list = this.getRoutes();
        for (RouteDefinition routeType : list) {
            if (!routeType.getId().equals(id)) continue;
            return new RouteResource(this, routeType);
        }
        return null;
    }

    @Path(value="{id}/{language}")
    public RouteResource getRoute(@PathParam(value="id") String id, @PathParam(value="language") String language) {
        RouteResource routeResource = this.getRoute(id);
        if (routeResource != null) {
            routeResource.setLanguage(language);
        }
        return routeResource;
    }

    public List<RouteDefinition> getRoutes() {
        return this.getRouteDefinitions().getRoutes();
    }
}

