/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.w3c.dom.Document;

@Converter(loader=true)
public final class NettyConverter {
    private NettyConverter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Converter
    public static byte[] toByteArray(ByteBuf buffer, Exchange exchange) {
        if (buffer.hasArray()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.readableBytes()];
        int readerIndex = buffer.readerIndex();
        buffer.retain();
        try {
            buffer.getBytes(readerIndex, bytes);
        }
        finally {
            buffer.release();
        }
        return bytes;
    }

    @Converter
    public static String toString(ByteBuf buffer, Exchange exchange) throws UnsupportedEncodingException {
        byte[] bytes = NettyConverter.toByteArray(buffer, exchange);
        if (exchange != null) {
            return (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, (Object)bytes);
        }
        return new String(bytes, "UTF-8");
    }

    @Converter
    public static InputStream toInputStream(ByteBuf buffer, Exchange exchange) {
        return new ByteBufInputStream(buffer);
    }

    @Converter
    public static ObjectInput toObjectInput(ByteBuf buffer, Exchange exchange) throws IOException {
        InputStream is = NettyConverter.toInputStream(buffer, exchange);
        return new ObjectInputStream(is);
    }

    @Converter
    public static ByteBuf toByteBuffer(byte[] bytes) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(bytes.length);
        buf.writeBytes(bytes);
        return buf;
    }

    @Converter
    public static ByteBuf toByteBuffer(String s, Exchange exchange) {
        byte[] bytes = exchange != null ? (byte[])exchange.getContext().getTypeConverter().convertTo(byte[].class, exchange, (Object)s) : s.getBytes();
        return NettyConverter.toByteBuffer(bytes);
    }

    @Converter
    public static Document toDocument(ByteBuf buffer, Exchange exchange) {
        InputStream is = NettyConverter.toInputStream(buffer, exchange);
        return (Document)exchange.getContext().getTypeConverter().convertTo(Document.class, exchange, (Object)is);
    }

    @Converter
    public static DOMSource toDOMSource(ByteBuf buffer, Exchange exchange) {
        InputStream is = NettyConverter.toInputStream(buffer, exchange);
        return (DOMSource)exchange.getContext().getTypeConverter().convertTo(DOMSource.class, exchange, (Object)is);
    }

    @Converter
    public static SAXSource toSAXSource(ByteBuf buffer, Exchange exchange) {
        InputStream is = NettyConverter.toInputStream(buffer, exchange);
        return (SAXSource)exchange.getContext().getTypeConverter().convertTo(SAXSource.class, exchange, (Object)is);
    }

    @Converter
    public static StreamSource toStreamSource(ByteBuf buffer, Exchange exchange) {
        InputStream is = NettyConverter.toInputStream(buffer, exchange);
        return (StreamSource)exchange.getContext().getTypeConverter().convertTo(StreamSource.class, exchange, (Object)is);
    }

    @Converter
    public static StAXSource toStAXSource(ByteBuf buffer, Exchange exchange) {
        InputStream is = NettyConverter.toInputStream(buffer, exchange);
        return (StAXSource)exchange.getContext().getTypeConverter().convertTo(StAXSource.class, exchange, (Object)is);
    }
}

