/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedStickyLoadBalancerMBean;
import org.apache.camel.management.mbean.ManagedProcessor;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.processor.loadbalancer.StickyLoadBalancer;

@ManagedResource(description="Managed Sticky LoadBalancer")
public class ManagedStickyLoadBalancer
extends ManagedProcessor
implements ManagedStickyLoadBalancerMBean {
    private final StickyLoadBalancer processor;

    public ManagedStickyLoadBalancer(CamelContext context, StickyLoadBalancer processor, LoadBalanceDefinition definition) {
        super(context, (Processor)processor, (ProcessorDefinition<?>)definition);
        this.processor = processor;
    }

    public LoadBalanceDefinition getDefinition() {
        return (LoadBalanceDefinition)super.getDefinition();
    }

    public String getExpressionLanguage() {
        StickyLoadBalancerDefinition sticky = (StickyLoadBalancerDefinition)this.getDefinition().getLoadBalancerType();
        return sticky.getCorrelationExpression().getExpressionType().getLanguage();
    }

    public String getExpression() {
        StickyLoadBalancerDefinition sticky = (StickyLoadBalancerDefinition)this.getDefinition().getLoadBalancerType();
        return sticky.getCorrelationExpression().getExpressionType().getExpression();
    }

    public Integer getSize() {
        return this.processor.getProcessors().size();
    }

    public String getLastChosenProcessorId() {
        LoadBalanceDefinition def;
        ProcessorDefinition output;
        int idx = this.processor.getLastChosenProcessorIndex();
        if (idx != -1 && (output = (ProcessorDefinition)(def = this.getDefinition()).getOutputs().get(idx)) != null) {
            return output.getId();
        }
        return null;
    }
}

