/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.jaxb;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.DeferredContextBinding;
import org.apache.camel.TypeConverter;
import org.apache.camel.TypeConverterLoaderException;
import org.apache.camel.converter.jaxb.FallbackTypeConverter;
import org.apache.camel.spi.TypeConverterLoader;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.support.SimpleTypeConverter;

@DeferredContextBinding
public final class FallbackTypeConverterLoader
implements TypeConverterLoader,
CamelContextAware {
    private CamelContext camelContext;
    private volatile FallbackTypeConverter fallbackTypeConverter;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void load(TypeConverterRegistry registry) throws TypeConverterLoaderException {
        this.registerFallbackConverters(registry);
    }

    private void registerFallbackConverters(TypeConverterRegistry registry) {
        FallbackTypeConverterLoader.addFallbackTypeConverter(registry, false, false, (type, exchange, value) -> this.getFallbackTypeConverter().convertTo(type, exchange, value, registry));
    }

    private static void addFallbackTypeConverter(TypeConverterRegistry registry, boolean allowNull, boolean canPromote, SimpleTypeConverter.ConversionMethod method) {
        registry.addFallbackTypeConverter((TypeConverter)new SimpleTypeConverter(allowNull, method), canPromote);
    }

    private FallbackTypeConverter getFallbackTypeConverter() {
        if (this.fallbackTypeConverter == null) {
            this.fallbackTypeConverter = new FallbackTypeConverter();
            CamelContextAware.trySetCamelContext((Object)this.fallbackTypeConverter, (CamelContext)this.camelContext);
        }
        return this.fallbackTypeConverter;
    }
}

