/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.extensions.spring.receivers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.ServiceObjectSupplier;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.extensions.spring.receivers.ApplicationContextHolder;
import org.apache.axis2.i18n.Messages;
import org.springframework.context.ApplicationContext;

public class SpringAppContextAwareObjectSupplier
implements ServiceObjectSupplier {
    public static final String SERVICE_SPRING_BEANNAME = "SpringBeanName";

    public Object getServiceObject(AxisService axisService) throws AxisFault {
        try {
            Parameter implBeanParam = axisService.getParameter(SERVICE_SPRING_BEANNAME);
            String beanName = ((String)implBeanParam.getValue()).trim();
            if (beanName != null) {
                ApplicationContext aCtx = ApplicationContextHolder.getContext();
                if (aCtx == null) {
                    throw new Exception("Axis2 Can't find Spring's ApplicationContext");
                }
                if (aCtx.getBean(beanName) == null) {
                    throw new Exception("Axis2 Can't find Spring Bean: " + beanName);
                }
                return aCtx.getBean(beanName);
            }
            throw new AxisFault(Messages.getMessage((String)"paramIsNotSpecified", (String)"SERVICE_SPRING_BEANNAME"));
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }
}

