/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.builder.XOPAwareStAXOMBuilder;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.builder.MTOMStAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.transport.http.HTTPConstants;

public class TransportUtils {
    private static final int BOM_SIZE = 4;

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext, String soapNamespaceURI) throws AxisFault {
        InputStream inStream = (InputStream)msgContext.getProperty("TRANSPORT_IN");
        msgContext.setProperty("TRANSPORT_IN", null);
        if (inStream == null) {
            throw new AxisFault(Messages.getMessage("inputstreamNull"));
        }
        return TransportUtils.createSOAPMessage(msgContext, inStream, soapNamespaceURI);
    }

    public static SOAPEnvelope createSOAPMessage(MessageContext msgContext, InputStream inStream, String soapNamespaceURI) throws AxisFault {
        try {
            SOAPEnvelope envelope;
            OperationContext opContext = msgContext.getOperationContext();
            if (opContext == null) {
                throw new AxisFault(Messages.getMessage("cannotBeNullOperationContext"));
            }
            Object contentType = opContext.getProperty("MTOM_RECEIVED");
            String charSetEnc = (String)msgContext.getProperty("CHARACTER_SET_ENCODING");
            if (charSetEnc == null) {
                charSetEnc = (String)opContext.getProperty("CHARACTER_SET_ENCODING");
            }
            if (charSetEnc == null) {
                charSetEnc = "UTF-8";
            }
            if (contentType != null) {
                msgContext.setDoingMTOM(true);
                StAXBuilder builder = TransportUtils.selectBuilderForMIME(msgContext, inStream, (String)contentType, true);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            } else if (msgContext.isDoingREST()) {
                XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((InputStream)inStream, (String)charSetEnc);
                SOAP11Factory soapFactory = new SOAP11Factory();
                StAXOMBuilder builder = new StAXOMBuilder(xmlreader);
                builder.setOMBuilderFactory((OMFactory)soapFactory);
                envelope = soapFactory.getDefaultEnvelope();
                envelope.getBody().addChild((OMNode)builder.getDocumentElement());
                builder = new StAXSOAPModelBuilder(envelope.getXMLStreamReader(), soapNamespaceURI);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            } else {
                XMLStreamReader xmlreader = StAXUtils.createXMLStreamReader((InputStream)inStream, (String)charSetEnc);
                StAXSOAPModelBuilder builder = new StAXSOAPModelBuilder(xmlreader, soapNamespaceURI);
                envelope = (SOAPEnvelope)builder.getDocumentElement();
            }
            return envelope;
        }
        catch (Exception e) {
            throw new AxisFault(e);
        }
    }

    public static String getCharSetEncoding(String contentType) {
        int index = contentType.indexOf(HTTPConstants.CHAR_SET_ENCODING);
        if (index == -1) {
            return "UTF-8";
        }
        int indexOfEq = contentType.indexOf("=", index);
        int indexOfSemiColon = contentType.indexOf(";", indexOfEq);
        String value = indexOfSemiColon > 0 ? contentType.substring(indexOfEq + 1, indexOfSemiColon) : contentType.substring(indexOfEq + 1, contentType.length()).trim();
        if ("null".equalsIgnoreCase(value = value.replaceAll("\"", ""))) {
            return null;
        }
        return value.trim();
    }

    public static StAXBuilder selectBuilderForMIME(MessageContext msgContext, InputStream inStream, String contentTypeString, boolean isSOAP) throws OMException, XMLStreamException, FactoryConfigurationError {
        XMLStreamReader streamReader;
        Attachments attachments;
        String charSetEncoding;
        boolean fileCacheForAttachments;
        XOPAwareStAXOMBuilder builder = null;
        Object cacheAttachmentProperty = msgContext.getProperty("cacheAttachments");
        String cacheAttachmentString = null;
        if (cacheAttachmentProperty != null && cacheAttachmentProperty instanceof String) {
            cacheAttachmentString = (String)cacheAttachmentProperty;
            fileCacheForAttachments = "true".equals(cacheAttachmentString);
        } else {
            Parameter parameter_cache_attachment = msgContext.getParameter("cacheAttachments");
            cacheAttachmentString = parameter_cache_attachment != null ? (String)parameter_cache_attachment.getValue() : null;
        }
        fileCacheForAttachments = "true".equals(cacheAttachmentString);
        String attachmentRepoDir = null;
        String attachmentSizeThreshold = null;
        if (fileCacheForAttachments) {
            Parameter attachmentRepoDirParameter;
            Object attachmentRepoDirProperty = msgContext.getProperty("attachmentDIR");
            attachmentRepoDir = attachmentRepoDirProperty != null ? (String)attachmentRepoDirProperty : ((attachmentRepoDirParameter = msgContext.getParameter("attachmentDIR")) != null ? (String)attachmentRepoDirParameter.getValue() : null);
            Object attachmentSizeThresholdProperty = msgContext.getProperty("sizeThreshold");
            if (attachmentSizeThresholdProperty != null && attachmentSizeThresholdProperty instanceof String) {
                attachmentSizeThreshold = (String)attachmentSizeThresholdProperty;
            } else {
                Parameter attachmentSizeThresholdParameter = msgContext.getParameter("sizeThreshold");
                attachmentSizeThreshold = attachmentSizeThresholdParameter.getValue().toString();
            }
        }
        if ((charSetEncoding = TransportUtils.getCharSetEncoding((attachments = new Attachments(inStream, contentTypeString, fileCacheForAttachments, attachmentRepoDir, attachmentSizeThreshold)).getSOAPPartContentType())) == null || "null".equalsIgnoreCase(charSetEncoding)) {
            charSetEncoding = "UTF-8";
        }
        try {
            streamReader = StAXUtils.createXMLStreamReader((Reader)TransportUtils.getReader(attachments.getSOAPPartInputStream(), charSetEncoding));
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
        msgContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
        msgContext.setProperty("Attachments", attachments);
        msgContext.setAttachmentMap(attachments);
        String soapEnvelopeNamespaceURI = null;
        if (contentTypeString.indexOf("application/soap+xml") > -1) {
            soapEnvelopeNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
        } else if (contentTypeString.indexOf("text/xml") > -1) {
            soapEnvelopeNamespaceURI = "http://schemas.xmlsoap.org/soap/envelope/";
        }
        if (isSOAP) {
            if (attachments.getAttachmentSpecType().equals("application/xop+xml") & null != soapEnvelopeNamespaceURI) {
                builder = new MTOMStAXSOAPModelBuilder(streamReader, attachments, soapEnvelopeNamespaceURI);
            } else if (attachments.getAttachmentSpecType().equals("text/xml") & null != soapEnvelopeNamespaceURI) {
                builder = new StAXSOAPModelBuilder(streamReader, soapEnvelopeNamespaceURI);
            }
        } else if (attachments.getAttachmentSpecType().equals("application/xop+xml")) {
            XOPAwareStAXOMBuilder stAXOMBuilder;
            builder = stAXOMBuilder = new XOPAwareStAXOMBuilder(streamReader, attachments);
        } else if (attachments.getAttachmentSpecType().equals("text/xml")) {
            builder = new StAXOMBuilder(streamReader);
        }
        return builder;
    }

    private static Reader getReader(InputStream is, String charSetEncoding) throws IOException {
        int unread;
        String encoding;
        PushbackInputStream is2 = new PushbackInputStream(is, 4);
        byte[] bom = new byte[4];
        int n = is2.read(bom, 0, bom.length);
        if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            encoding = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            encoding = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            encoding = "UTF-16LE";
            unread = n - 2;
        } else if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            encoding = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            encoding = "UTF-32LE";
            unread = n - 4;
        } else {
            encoding = charSetEncoding;
            unread = n;
        }
        if (unread > 0) {
            is2.unread(bom, n - unread, unread);
        }
        return new BufferedReader(new InputStreamReader((InputStream)is2, encoding));
    }
}

