/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.schema.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.axis2.schema.BeanWriterMetaInfoHolder;
import org.apache.axis2.schema.CompilerOptions;
import org.apache.axis2.schema.SchemaCompilationException;
import org.apache.axis2.schema.i18n.SchemaCompilerMessages;
import org.apache.axis2.schema.typemap.JavaTypeMap;
import org.apache.axis2.schema.util.PrimitiveTypeFinder;
import org.apache.axis2.schema.util.SchemaPropertyLoader;
import org.apache.axis2.schema.writer.BeanWriter;
import org.apache.axis2.util.FileWriter;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.XSLTTemplateProcessor;
import org.apache.axis2.util.XSLTUtils;
import org.apache.axis2.wsdl.databinding.CUtils;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CStructWriter
implements BeanWriter {
    public static final String WRAPPED_DATABINDING_CLASS_NAME = "WrappedDatabinder";
    public static final String EXTENSION_MAPPER_CLASSNAME = "extension_mapper";
    public static final String AXIS2_PREFIX = "adb_";
    private String javaBeanTemplateName = null;
    private boolean templateLoaded = false;
    private Templates sourceTemplateCache;
    private Templates headerTemplateCache;
    private List<String> namesList;
    private static int count = 0;
    private boolean wrapClasses = false;
    private boolean writeClasses = false;
    protected File rootDir;
    private Document globalWrappedSourceDocument;
    private Document globalWrappedHeaderDocument;
    private Map modelMap = new HashMap();
    private static final String ADB_CLASS_PREFIX = "adb_";
    private static final String ADB_CLASS_POSTFIX = "_t*";
    private static final String DEFAULT_C_CLASS_NAME = "axiom_node_t*";
    private Map baseTypeMap = new JavaTypeMap().getTypeMap();
    public static final String DEFAULT_CLASS_NAME = "axiom_node_t*";
    public static final String DEFAULT_CLASS_ARRAY_NAME = "axiom_node_t*";
    public static final String DEFAULT_ATTRIB_CLASS_NAME = "axiom_attribute_t*";
    public static final String DEFAULT_ATTRIB_ARRAY_CLASS_NAME = "axiom_attribute_t*";
    public static final String DEFAULT_TYPE_NS = "http://www.w3.org/2001/XMLSchema";
    private int lastPrefixIndex = 1;
    HashMap<String, String> mapURItoPrefix = new HashMap();
    HashMap<String, String> mapPrefixtoURI = new HashMap();

    @Override
    public Map getModelMap() {
        return this.modelMap;
    }

    @Override
    public String getDefaultClassName() {
        return "axiom_node_t*";
    }

    @Override
    public String getDefaultClassArrayName() {
        return "axiom_node_t*";
    }

    @Override
    public String getDefaultAttribClassName() {
        return "axiom_attribute_t*";
    }

    @Override
    public String getDefaultAttribArrayClassName() {
        return "axiom_attribute_t*";
    }

    @Override
    public void init(CompilerOptions options) throws SchemaCompilationException {
        try {
            this.initWithFile(options.getOutputLocation());
            this.writeClasses = options.isWriteOutput();
            this.wrapClasses = !this.writeClasses ? false : options.isWrapClasses();
            if (options.isWrapClasses()) {
                this.globalWrappedSourceDocument = XSLTUtils.getDocument();
                Element rootElement = XSLTUtils.getElement((Document)this.globalWrappedSourceDocument, (String)"beans");
                this.globalWrappedSourceDocument.appendChild(rootElement);
                XSLTUtils.addAttribute((Document)this.globalWrappedSourceDocument, (String)"name", (String)WRAPPED_DATABINDING_CLASS_NAME, (Element)rootElement);
                this.globalWrappedHeaderDocument = XSLTUtils.getDocument();
                rootElement = XSLTUtils.getElement((Document)this.globalWrappedHeaderDocument, (String)"beans");
                this.globalWrappedHeaderDocument.appendChild(rootElement);
                XSLTUtils.addAttribute((Document)this.globalWrappedHeaderDocument, (String)"name", (String)WRAPPED_DATABINDING_CLASS_NAME, (Element)rootElement);
            }
        }
        catch (IOException e) {
            throw new SchemaCompilationException(e);
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(XmlSchemaElement element, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = element.getQName();
            return this.process(qName, metainf, typeMap, groupTypeMap, true, false);
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(QName qName, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf, boolean isAbstract) throws SchemaCompilationException {
        try {
            return this.process(qName, metainf, typeMap, groupTypeMap, false, isAbstract);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public void writeBatch() throws SchemaCompilationException {
        try {
            if (this.wrapClasses) {
                File outSource = this.createOutFile(WRAPPED_DATABINDING_CLASS_NAME, ".c", null);
                File outHeader = this.createOutFile(WRAPPED_DATABINDING_CLASS_NAME, ".h", null);
                this.parseSource(this.globalWrappedSourceDocument, outSource);
                this.parseHeader(this.globalWrappedHeaderDocument, outHeader);
            }
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String write(XmlSchemaSimpleType simpleType, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, BeanWriterMetaInfoHolder metainf) throws SchemaCompilationException {
        try {
            QName qName = simpleType.getQName();
            if (qName == null) {
                qName = (QName)simpleType.getMetaInfoMap().get("Q_NAME");
            }
            metainf.addtStatus(qName, 64);
            return this.process(qName, metainf, typeMap, groupTypeMap, true, false);
        }
        catch (SchemaCompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCompilationException(e);
        }
    }

    private void initWithFile(File rootDir) throws IOException {
        if (rootDir == null) {
            this.rootDir = new File(".");
        } else {
            if (!rootDir.isDirectory()) {
                throw new IOException(SchemaCompilerMessages.getMessage("schema.rootnotfolderexception"));
            }
            this.rootDir = rootDir;
        }
        this.namesList = new ArrayList<String>();
        this.javaBeanTemplateName = SchemaPropertyLoader.getBeanTemplate();
    }

    @Override
    public String makeFullyQualifiedClassName(QName qName) {
        String originalName = qName.getLocalPart();
        return this.makeUniqueCStructName(this.namesList, originalName);
    }

    private String process(QName qName, BeanWriterMetaInfoHolder metainf, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isElement, boolean isAbstract) throws Exception {
        String fullyQualifiedClassName = metainf.getOwnClassName();
        if (fullyQualifiedClassName == null) {
            fullyQualifiedClassName = this.makeFullyQualifiedClassName(qName);
        }
        String className = fullyQualifiedClassName;
        String originalName = qName == null ? "" : qName.getLocalPart();
        ArrayList<String> propertyNames = new ArrayList<String>();
        if (!this.templateLoaded) {
            this.loadTemplate();
        }
        if (this.wrapClasses) {
            this.globalWrappedSourceDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedSourceDocument, className, originalName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
            this.globalWrappedHeaderDocument.getDocumentElement().appendChild(this.getBeanElement(this.globalWrappedHeaderDocument, className, originalName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
        } else {
            Document modelSource = XSLTUtils.getDocument();
            Document modelHeader = XSLTUtils.getDocument();
            modelSource.appendChild(this.getBeanElement(modelSource, className, originalName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
            modelHeader.appendChild(this.getBeanElement(modelHeader, className, originalName, qName, isElement, isAbstract, metainf, propertyNames, typeMap, groupTypeMap));
            if (this.writeClasses) {
                String fileName = className.substring(4, className.length() - 3);
                File outSource = this.createOutFile(fileName, ".c", null);
                File outHeader = this.createOutFile(fileName, ".h", null);
                this.parseSource(modelSource, outSource);
                this.parseHeader(modelHeader, outHeader);
            }
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), modelSource);
            this.modelMap.put(new QName(qName.getNamespaceURI(), className), modelHeader);
        }
        return fullyQualifiedClassName;
    }

    private Element getBeanElement(Document model, String className, String originalName, QName qName, boolean isElement, boolean isAbstract, BeanWriterMetaInfoHolder metainf, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap) throws SchemaCompilationException {
        Element rootElt = XSLTUtils.getElement((Document)model, (String)"class");
        String strippedClassName = className.substring(4, className.length() - 3);
        XSLTUtils.addAttribute((Document)model, (String)"name", (String)strippedClassName, (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"originalName", (String)originalName, (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)qName.getNamespaceURI(), (Element)rootElt);
        XSLTUtils.addAttribute((Document)model, (String)"nsprefix", (String)this.getPrefixForURI(qName.getNamespaceURI(), qName.getPrefix()), (Element)rootElt);
        String capsName = strippedClassName.toUpperCase();
        XSLTUtils.addAttribute((Document)model, (String)"caps-name", (String)capsName, (Element)rootElt);
        if (!this.wrapClasses) {
            XSLTUtils.addAttribute((Document)model, (String)"unwrapped", (String)"yes", (Element)rootElt);
        }
        if (isAbstract) {
            XSLTUtils.addAttribute((Document)model, (String)"isAbstract", (String)"yes", (Element)rootElt);
        }
        if (!this.writeClasses) {
            XSLTUtils.addAttribute((Document)model, (String)"skip-write", (String)"yes", (Element)rootElt);
        }
        if (!isElement) {
            XSLTUtils.addAttribute((Document)model, (String)"type", (String)"yes", (Element)rootElt);
        }
        if (metainf.isAnonymous()) {
            XSLTUtils.addAttribute((Document)model, (String)"anon", (String)"yes", (Element)rootElt);
        }
        if (metainf.isExtension()) {
            XSLTUtils.addAttribute((Document)model, (String)"extension", (String)metainf.getExtensionClassName(), (Element)rootElt);
        }
        if (metainf.isRestriction()) {
            XSLTUtils.addAttribute((Document)model, (String)"restriction", (String)metainf.getRestrictionClassName(), (Element)rootElt);
        }
        if (metainf.isChoice()) {
            XSLTUtils.addAttribute((Document)model, (String)"choice", (String)"yes", (Element)rootElt);
        }
        if (metainf.isSimple()) {
            XSLTUtils.addAttribute((Document)model, (String)"simple", (String)"yes", (Element)rootElt);
        }
        if (metainf.isUnion()) {
            XSLTUtils.addAttribute((Document)model, (String)"union", (String)"yes", (Element)rootElt);
        }
        if (metainf.isList()) {
            XSLTUtils.addAttribute((Document)model, (String)"list", (String)"yes", (Element)rootElt);
        }
        if (metainf.isOrdered()) {
            XSLTUtils.addAttribute((Document)model, (String)"ordered", (String)"yes", (Element)rootElt);
        }
        if (isElement && metainf.isNillable(qName)) {
            XSLTUtils.addAttribute((Document)model, (String)"nillable", (String)"yes", (Element)rootElt);
        }
        if (metainf.isParticleClass()) {
            XSLTUtils.addAttribute((Document)model, (String)"particleClass", (String)"yes", (Element)rootElt);
        }
        if (metainf.isHasParticleType()) {
            XSLTUtils.addAttribute((Document)model, (String)"hasParticleType", (String)"yes", (Element)rootElt);
        }
        this.populateInfo(metainf, model, rootElt, propertyNames, typeMap, groupTypeMap, false);
        if (metainf.isSimple() && metainf.isUnion()) {
            this.populateMemberInfo(metainf, model, rootElt, typeMap);
        }
        if (metainf.isSimple() && metainf.isList()) {
            this.populateListInfo(metainf, model, rootElt, typeMap, groupTypeMap);
        }
        return rootElt;
    }

    protected void populateListInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElement, Map<QName, String> typeMap, Map<QName, String> groupTypeMap) {
        String cName = this.makeUniqueCStructName(new ArrayList<String>(), metainf.getItemTypeQName().getLocalPart());
        Element itemType = XSLTUtils.addChildElement((Document)model, (String)"itemtype", (Node)rootElement);
        XSLTUtils.addAttribute((Document)model, (String)"type", (String)metainf.getItemTypeClassName(), (Element)itemType);
        XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)metainf.getItemTypeQName().getNamespaceURI(), (Element)itemType);
        XSLTUtils.addAttribute((Document)model, (String)"originalName", (String)metainf.getItemTypeQName().getLocalPart(), (Element)itemType);
        XSLTUtils.addAttribute((Document)model, (String)"cname", (String)cName.substring(4, cName.length() - 3), (Element)itemType);
        if (typeMap.containsKey(metainf.getItemTypeQName()) || groupTypeMap.containsKey(metainf.getItemTypeClassName())) {
            XSLTUtils.addAttribute((Document)model, (String)"ours", (String)"true", (Element)itemType);
        }
        if (PrimitiveTypeFinder.isPrimitive(metainf.getItemTypeClassName())) {
            XSLTUtils.addAttribute((Document)model, (String)"primitive", (String)"yes", (Element)itemType);
        }
    }

    protected void populateMemberInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElement, Map<QName, String> typeMap) {
        Map<QName, String> memberTypes = metainf.getMemberTypes();
        for (QName memberQName : memberTypes.keySet()) {
            String memberClass = memberTypes.get(memberQName);
            Element memberType = XSLTUtils.addChildElement((Document)model, (String)"memberType", (Node)rootElement);
            XSLTUtils.addAttribute((Document)model, (String)"type", (String)memberClass, (Element)memberType);
            XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)memberQName.getNamespaceURI(), (Element)memberType);
            XSLTUtils.addAttribute((Document)model, (String)"originalName", (String)memberQName.getLocalPart(), (Element)memberType);
            XSLTUtils.addAttribute((Document)model, (String)"caps-originalName", (String)memberQName.getLocalPart().toUpperCase(), (Element)memberType);
            if (!typeMap.containsKey(memberQName)) continue;
            XSLTUtils.addAttribute((Document)model, (String)"ours", (String)"true", (Element)memberType);
        }
    }

    private void populateInfo(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isInherited) throws SchemaCompilationException {
        if (metainf.getParent() != null && (!metainf.isRestriction() || metainf.isRestriction() && metainf.isSimple())) {
            this.populateInfo(metainf.getParent(), model, rootElt, propertyNames, typeMap, groupTypeMap, true);
        }
        this.addPropertyEntries(metainf, model, rootElt, propertyNames, typeMap, groupTypeMap, isInherited);
    }

    private void addPropertyEntries(BeanWriterMetaInfoHolder metainf, Document model, Element rootElt, ArrayList<String> propertyNames, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, boolean isInherited) throws SchemaCompilationException {
        ArrayList<QName> missingQNames = new ArrayList<QName>();
        ArrayList<QName> qNames = new ArrayList<QName>();
        BeanWriterMetaInfoHolder parentMetaInf = metainf.getParent();
        QName[] qName = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int i = 0; i < qName.length; ++i) {
            qNames.add(qName[i]);
        }
        if (metainf.isRestriction() && !metainf.isSimple()) {
            this.addMissingQNames(metainf, qNames, missingQNames);
        }
        for (int i = 0; i < qName.length; ++i) {
            QName schemaQName;
            Element property = XSLTUtils.addChildElement((Document)model, (String)"property", (Node)rootElt);
            QName name = qName[i];
            String xmlName = this.makeUniqueCStructName(new ArrayList<String>(), name.getLocalPart());
            XSLTUtils.addAttribute((Document)model, (String)"name", (String)name.getLocalPart(), (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"originalName", (String)name.getLocalPart(), (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)name.getNamespaceURI(), (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"prefix", (String)name.getPrefix(), (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"cname", (String)xmlName.substring(4, xmlName.length() - 3), (Element)property);
            String CClassNameForElement = metainf.getClassNameForQName(name);
            if (CClassNameForElement == null) {
                CClassNameForElement = "axiom_node_t*";
            }
            CClassNameForElement = this.getShortTypeName(CClassNameForElement);
            XSLTUtils.addAttribute((Document)model, (String)"type", (String)CClassNameForElement, (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"caps-cname", (String)xmlName.substring(4, xmlName.length() - 3).toUpperCase(), (Element)property);
            XSLTUtils.addAttribute((Document)model, (String)"caps-type", (String)CClassNameForElement.toUpperCase(), (Element)property);
            if (PrimitiveTypeFinder.isPrimitive(CClassNameForElement)) {
                XSLTUtils.addAttribute((Document)model, (String)"primitive", (String)"yes", (Element)property);
            }
            if (this.isDefault(CClassNameForElement)) {
                XSLTUtils.addAttribute((Document)model, (String)"default", (String)"yes", (Element)property);
            }
            if (metainf.isDefaultValueAvailable(name) && this.baseTypeMap.containsKey(schemaQName = metainf.getSchemaQNameForQName(name))) {
                XSLTUtils.addAttribute((Document)model, (String)"defaultValue", (String)metainf.getDefaultValueForQName(name), (Element)property);
            }
            if (typeMap.containsKey(metainf.getSchemaQNameForQName(name)) || (metainf.getSchemaQNameForQName(name) == null || !metainf.getSchemaQNameForQName(name).getNamespaceURI().equals(DEFAULT_TYPE_NS)) && !CClassNameForElement.equals("axiom_node_t*") && !CClassNameForElement.equals("axiom_attribute_t*")) {
                XSLTUtils.addAttribute((Document)model, (String)"ours", (String)"yes", (Element)property);
            }
            if (metainf.getAttributeStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"attribute", (String)"yes", (Element)property);
            } else {
                XSLTUtils.addAttribute((Document)model, (String)"notattribute", (String)"yes", (Element)property);
            }
            if (metainf.isNillable(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"nillable", (String)"yes", (Element)property);
            }
            String shortTypeName = metainf.getSchemaQNameForQName(name) != null ? (this.baseTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) ? metainf.getSchemaQNameForQName(name).getLocalPart() : this.getShortTypeName(CClassNameForElement)) : this.getShortTypeName(CClassNameForElement);
            XSLTUtils.addAttribute((Document)model, (String)"shorttypename", (String)shortTypeName, (Element)property);
            if (isInherited) {
                XSLTUtils.addAttribute((Document)model, (String)"inherited", (String)"yes", (Element)property);
            }
            if (metainf.getAnyStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"any", (String)"yes", (Element)property);
            }
            if (metainf.getBinaryStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"binary", (String)"yes", (Element)property);
            }
            if (metainf.getSimpleStatusForQName(name)) {
                XSLTUtils.addAttribute((Document)model, (String)"simple", (String)"yes", (Element)property);
            }
            long minOccurs = metainf.getMinOccurs(name);
            XSLTUtils.addAttribute((Document)model, (String)"minOccurs", (String)(minOccurs + ""), (Element)property);
            if (metainf.getArrayStatusForQName(name)) {
                String attrName = name.getLocalPart();
                int arrayTokenStart = attrName.indexOf("Array");
                if (arrayTokenStart >= 0) {
                    String arrayEle = attrName.substring(0, arrayTokenStart);
                    XSLTUtils.addAttribute((Document)model, (String)"arrayele", (String)arrayEle, (Element)property);
                }
                XSLTUtils.addAttribute((Document)model, (String)"isarray", (String)"yes", (Element)property);
                XSLTUtils.addAttribute((Document)model, (String)"arrayBaseType", (String)CClassNameForElement, (Element)property);
                long maxOccurs = metainf.getMaxOccurs(name);
                if (maxOccurs == Long.MAX_VALUE) {
                    XSLTUtils.addAttribute((Document)model, (String)"unbound", (String)"yes", (Element)property);
                }
                XSLTUtils.addAttribute((Document)model, (String)"maxOccurs", (String)(maxOccurs + ""), (Element)property);
            }
            if (parentMetaInf != null && metainf.isRestriction() && missingQNames.contains(name)) {
                this.addAttributesToProperty(parentMetaInf, name, model, property, typeMap, groupTypeMap, CClassNameForElement);
                continue;
            }
            this.addAttributesToProperty(metainf, name, model, property, typeMap, groupTypeMap, CClassNameForElement);
        }
    }

    private void addAttributesToProperty(BeanWriterMetaInfoHolder metainf, QName name, Document model, Element property, Map<QName, String> typeMap, Map<QName, String> groupTypeMap, String CClassNameForElement) {
        if (metainf.getDefaultStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"default", (String)"yes", (Element)property);
        }
        if (typeMap.containsKey(metainf.getSchemaQNameForQName(name)) || groupTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) || (metainf.getSchemaQNameForQName(name) == null || !metainf.getSchemaQNameForQName(name).getNamespaceURI().equals(DEFAULT_TYPE_NS)) && !CClassNameForElement.equals("axiom_node_t*") && !CClassNameForElement.equals("axiom_attribute_t*")) {
            XSLTUtils.addAttribute((Document)model, (String)"ours", (String)"yes", (Element)property);
        }
        if (metainf.getAttributeStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"attribute", (String)"yes", (Element)property);
        }
        if (metainf.isNillable(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"nillable", (String)"yes", (Element)property);
        }
        if (metainf.getOptionalAttributeStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"optional", (String)"yes", (Element)property);
        }
        String shortTypeName = metainf.getSchemaQNameForQName(name) != null ? (this.baseTypeMap.containsKey(metainf.getSchemaQNameForQName(name)) ? metainf.getSchemaQNameForQName(name).getLocalPart() : this.getShortTypeName(CClassNameForElement)) : this.getShortTypeName(CClassNameForElement);
        XSLTUtils.addAttribute((Document)model, (String)"shorttypename", (String)shortTypeName, (Element)property);
        if (metainf.getAnyStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"any", (String)"yes", (Element)property);
        }
        if (metainf.getBinaryStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"binary", (String)"yes", (Element)property);
        }
        if (metainf.isSimple() || metainf.getSimpleStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"simple", (String)"yes", (Element)property);
        }
        long minOccurs = metainf.getMinOccurs(name);
        XSLTUtils.addAttribute((Document)model, (String)"minOccurs", (String)(minOccurs + ""), (Element)property);
        if (metainf.getArrayStatusForQName(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"array", (String)"yes", (Element)property);
            int endIndex = CClassNameForElement.indexOf("[");
            if (endIndex >= 0) {
                XSLTUtils.addAttribute((Document)model, (String)"arrayBaseType", (String)CClassNameForElement.substring(0, endIndex), (Element)property);
            } else {
                XSLTUtils.addAttribute((Document)model, (String)"arrayBaseType", (String)CClassNameForElement, (Element)property);
            }
            long maxOccurs = metainf.getMaxOccurs(name);
            if (maxOccurs == Long.MAX_VALUE) {
                XSLTUtils.addAttribute((Document)model, (String)"unbound", (String)"yes", (Element)property);
            } else {
                XSLTUtils.addAttribute((Document)model, (String)"maxOccurs", (String)(maxOccurs + ""), (Element)property);
            }
        }
        if (metainf.isRestrictionBaseType(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"restrictionBaseType", (String)"yes", (Element)property);
        }
        if (metainf.isExtensionBaseType(name)) {
            XSLTUtils.addAttribute((Document)model, (String)"extensionBaseType", (String)"yes", (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getLengthFacet() != -1L) {
            XSLTUtils.addAttribute((Document)model, (String)"lenFacet", (String)(metainf.getLengthFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxLengthFacet() != -1L) {
            XSLTUtils.addAttribute((Document)model, (String)"maxLenFacet", (String)(metainf.getMaxLengthFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinLengthFacet() != -1L) {
            XSLTUtils.addAttribute((Document)model, (String)"minLenFacet", (String)(metainf.getMinLengthFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxExclusiveFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"maxExFacet", (String)(metainf.getMaxExclusiveFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinExclusiveFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"minExFacet", (String)(metainf.getMinExclusiveFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMaxInclusiveFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"maxInFacet", (String)(metainf.getMaxInclusiveFacet() + ""), (Element)property);
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getMinInclusiveFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"minInFacet", (String)(metainf.getMinInclusiveFacet() + ""), (Element)property);
        }
        if (!metainf.getEnumFacet().isEmpty()) {
            boolean validJava = true;
            for (String value : metainf.getEnumFacet()) {
                if (JavaUtils.isJavaId((String)value)) continue;
                validJava = false;
            }
            int id = 0;
            for (String attribValue : metainf.getEnumFacet()) {
                Element enumFacet = XSLTUtils.addChildElement((Document)model, (String)"enumFacet", (Node)property);
                XSLTUtils.addAttribute((Document)model, (String)"value", (String)attribValue, (Element)enumFacet);
                if (validJava) {
                    XSLTUtils.addAttribute((Document)model, (String)"id", (String)attribValue.toUpperCase(), (Element)enumFacet);
                    continue;
                }
                XSLTUtils.addAttribute((Document)model, (String)"id", (String)(attribValue.toUpperCase().replaceAll("[^A-Z0-9]", "_") + "_" + ++id), (Element)enumFacet);
            }
        }
        if (metainf.isRestrictionBaseType(name) && metainf.getPatternFacet() != null) {
            XSLTUtils.addAttribute((Document)model, (String)"patternFacet", (String)metainf.getPatternFacet(), (Element)property);
        }
    }

    private void addMissingQNames(BeanWriterMetaInfoHolder metainf, ArrayList<QName> qName, ArrayList<QName> missingQNames) {
        int i;
        QName[] qNames = null;
        QName[] pQNames = null;
        BeanWriterMetaInfoHolder parentMetaInf = metainf.getParent();
        qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        if (parentMetaInf != null) {
            pQNames = parentMetaInf.isOrdered() ? parentMetaInf.getOrderedQNameArray() : parentMetaInf.getQNameArray();
        }
        for (i = 0; pQNames != null && i < pQNames.length; ++i) {
            if (!this.qNameNotFound(pQNames[i], metainf)) continue;
            missingQNames.add(pQNames[i]);
        }
        if (!missingQNames.isEmpty()) {
            for (i = 0; i < missingQNames.size(); ++i) {
                qName.add(missingQNames.get(i));
            }
        }
    }

    private boolean qNameNotFound(QName qname, BeanWriterMetaInfoHolder metainf) {
        boolean found = false;
        QName[] qNames = metainf.isOrdered() ? metainf.getOrderedQNameArray() : metainf.getQNameArray();
        for (int j = 0; j < qNames.length; ++j) {
            if (!qname.getLocalPart().equals(qNames[j].getLocalPart())) continue;
            found = true;
        }
        return !found;
    }

    private boolean isDefault(String CClassNameForElement) {
        return this.getDefaultClassName().equals(CClassNameForElement) || this.getDefaultClassArrayName().equals(CClassNameForElement);
    }

    private String makeUniqueCStructName(List<String> listOfNames, String xmlName) {
        String cName = CUtils.isCKeyword((String)xmlName) ? CUtils.makeNonCKeyword((String)xmlName) : xmlName;
        cName = cName.replace('.', '_');
        cName = cName.replace('-', '_');
        while (listOfNames.contains(cName.toLowerCase())) {
            cName = !listOfNames.contains((cName + "E").toLowerCase()) ? cName + "E" : cName + count++;
            cName = cName + count++;
        }
        listOfNames.add(cName.toLowerCase());
        String modifiedCName = "adb_" + cName + ADB_CLASS_POSTFIX;
        return modifiedCName;
    }

    private void loadTemplate() throws SchemaCompilationException {
        Class<?> clazz = this.getClass();
        String templateName = this.javaBeanTemplateName;
        if (templateName != null) {
            try {
                String sourceTemplateName = templateName + "Source.xsl";
                InputStream xslStream = clazz.getResourceAsStream(sourceTemplateName);
                this.sourceTemplateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xslStream));
                String headerTemplateName = templateName + "Header.xsl";
                xslStream = clazz.getResourceAsStream(headerTemplateName);
                this.headerTemplateCache = TransformerFactory.newInstance().newTemplates(new StreamSource(xslStream));
                this.templateLoaded = true;
            }
            catch (TransformerConfigurationException e) {
                throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateLoadException"), e);
            }
        } else {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.templateNotFoundException"));
        }
    }

    protected File createOutFile(String fileName, String extension, String prefix) throws Exception {
        return FileWriter.createClassFile((File)this.rootDir, (String)"", (String)((prefix == null ? "adb_" : prefix) + fileName), (String)extension);
    }

    private void parseSource(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, (Document)doc, (Transformer)this.sourceTemplateCache.newTransformer());
        ((OutputStream)outStream).write(10);
        ((OutputStream)outStream).write(10);
        outStream.flush();
        ((OutputStream)outStream).close();
    }

    private void parseHeader(Document doc, File outputFile) throws Exception {
        FileOutputStream outStream = new FileOutputStream(outputFile);
        XSLTTemplateProcessor.parse((OutputStream)outStream, (Document)doc, (Transformer)this.headerTemplateCache.newTransformer());
        ((OutputStream)outStream).write(10);
        ((OutputStream)outStream).write(10);
        outStream.flush();
        ((OutputStream)outStream).close();
    }

    public String getPrefixForURI(String uri) {
        return this.getPrefixForURI(uri, null);
    }

    public String getPrefixForURI(String uri, String defaultPrefix) {
        if (uri == null || uri.length() == 0) {
            return null;
        }
        String prefix = this.mapURItoPrefix.get(uri);
        if (prefix == null) {
            if (defaultPrefix == null || defaultPrefix.length() == 0) {
                prefix = "ns" + this.lastPrefixIndex++;
                while (this.mapPrefixtoURI.get(prefix) != null) {
                    prefix = "ns" + this.lastPrefixIndex++;
                }
            } else {
                prefix = defaultPrefix;
            }
            this.mapPrefixtoURI.put(prefix, uri);
            this.mapURItoPrefix.put(uri, prefix);
        }
        return prefix;
    }

    private String getShortTypeName(String typeClassName) {
        if (typeClassName.endsWith("[]")) {
            typeClassName = typeClassName.substring(0, typeClassName.lastIndexOf("["));
        }
        return typeClassName;
    }

    @Override
    public void registerExtensionMapperPackageName(String mapperPackageName) {
    }

    @Override
    public void writeExtensionMapper(BeanWriterMetaInfoHolder[] metainfArray) throws SchemaCompilationException {
        try {
            Document model = XSLTUtils.getDocument();
            Element rootElt = XSLTUtils.getElement((Document)model, (String)"mapper");
            Element rootElt2 = XSLTUtils.getElement((Document)model, (String)"mapper");
            String extMapperName = EXTENSION_MAPPER_CLASSNAME;
            if (!this.wrapClasses) {
                XSLTUtils.addAttribute((Document)model, (String)"unwrapped", (String)"yes", (Element)rootElt);
            }
            if (!this.writeClasses) {
                XSLTUtils.addAttribute((Document)model, (String)"skip-write", (String)"yes", (Element)rootElt);
            }
            for (BeanWriterMetaInfoHolder metainf : metainfArray) {
                QName ownQname = metainf.getOwnQname();
                String className = metainf.getOwnClassName();
                if (ownQname == null) continue;
                Element typeChild = XSLTUtils.addChildElement((Document)model, (String)"type", (Node)rootElt);
                XSLTUtils.addAttribute((Document)model, (String)"nsuri", (String)ownQname.getNamespaceURI(), (Element)typeChild);
                XSLTUtils.addAttribute((Document)model, (String)"classname", (String)(className == null ? "" : className), (Element)typeChild);
                XSLTUtils.addAttribute((Document)model, (String)"shortname", (String)(ownQname == null ? "" : ownQname.getLocalPart()), (Element)typeChild);
            }
            model.appendChild(rootElt);
            if (!this.templateLoaded) {
                this.loadTemplate();
            }
            if (this.wrapClasses) {
                rootElt2 = (Element)this.globalWrappedSourceDocument.importNode(rootElt, true);
                this.globalWrappedSourceDocument.getDocumentElement().appendChild(rootElt2);
                XSLTUtils.addAttribute((Document)this.globalWrappedSourceDocument, (String)"name", (String)extMapperName, (Element)rootElt2);
                XSLTUtils.addAttribute((Document)this.globalWrappedSourceDocument, (String)"caps-name", (String)extMapperName.toUpperCase(), (Element)rootElt2);
                rootElt2 = (Element)this.globalWrappedHeaderDocument.importNode(rootElt, true);
                this.globalWrappedHeaderDocument.getDocumentElement().appendChild(rootElt2);
                XSLTUtils.addAttribute((Document)this.globalWrappedHeaderDocument, (String)"name", (String)extMapperName, (Element)rootElt2);
                XSLTUtils.addAttribute((Document)this.globalWrappedHeaderDocument, (String)"caps-name", (String)extMapperName.toUpperCase(), (Element)rootElt2);
            } else {
                XSLTUtils.addAttribute((Document)model, (String)"name", (String)extMapperName, (Element)model.getDocumentElement());
                XSLTUtils.addAttribute((Document)model, (String)"caps-name", (String)extMapperName.toUpperCase(), (Element)rootElt);
                if (this.writeClasses) {
                    File outSource = this.createOutFile(extMapperName, ".c", "axis2_");
                    File outHeader = this.createOutFile(extMapperName, ".h", "axis2_");
                    this.parseSource(model, outSource);
                    this.parseHeader(model, outHeader);
                }
                this.modelMap.put(new QName(extMapperName), model);
                this.modelMap.put(new QName(extMapperName), model);
            }
        }
        catch (ParserConfigurationException e) {
            throw new SchemaCompilationException(SchemaCompilerMessages.getMessage("schema.document.error"), e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SchemaCompilationException(e);
        }
    }

    @Override
    public String getExtensionMapperPackageName() {
        return null;
    }
}

