/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XMLUtilImpl {
    private XMLUtilImpl() {
    }

    static void write(Document document, OutputStream outputStream, String string) throws IOException {
        try {
            try {
                XMLUtilImpl.writeXerces(document, outputStream, string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                XMLUtilImpl.writeJaxp(document, outputStream, string);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw (IOException)new IOException(throwable.toString()).initCause(throwable);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw (IOException)new IOException("Could not find a safe DOM serializer: " + exception).initCause(exception);
        }
    }

    private static void writeCrimson(Document document, OutputStream outputStream, String string) throws IllegalArgumentException, Exception {
        String string2 = document.getClass().getName();
        if (XMLUtilImpl.hasNamespaces(document)) {
            throw new IllegalArgumentException("No namespace writing support in Crimson!");
        }
        if (!string2.equals("com.sun.xml.tree.XmlDocument") && !string2.equals("org.apache.crimson.tree.XmlDocument")) {
            throw new IllegalArgumentException("Not a Crimson document");
        }
        Method method = document.getClass().getDeclaredMethod("write", OutputStream.class);
        method.invoke((Object)document, outputStream);
    }

    private static void writeXerces(Document document, OutputStream outputStream, String string) throws ClassNotFoundException, Exception {
        ClassLoader classLoader = document.getClass().getClassLoader();
        Class<?> clazz = null;
        String string2 = "XMLSerializer";
        String string3 = "org.apache.xml.serialize.";
        String string4 = "com.sun.org.apache.xml.internal.serialize.";
        boolean bl = false;
        try {
            clazz = Class.forName(string3 + string2, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                clazz = Class.forName(string4 + string2, true, classLoader);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                // empty catch block
            }
        }
        if (clazz == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
            try {
                clazz = Class.forName(string3 + string2, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Class.forName(string4 + string2, true, classLoader);
                    bl = true;
                }
                catch (ClassNotFoundException classNotFoundException3) {
                    // empty catch block
                }
            }
        }
        if (clazz == null) {
            classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            if (classLoader == null) {
                classLoader = XMLUtilImpl.class.getClassLoader();
            }
            try {
                clazz = Class.forName(string3 + string2, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = Class.forName(string4 + string2, true, classLoader);
                bl = true;
            }
        }
        Class<?> clazz2 = Class.forName((bl ? string4 : string3) + "OutputFormat", true, classLoader);
        Object obj = clazz.newInstance();
        Object obj2 = clazz2.newInstance();
        Method method = null;
        method = clazz2.getMethod("setMethod", String.class);
        method.invoke(obj2, "xml");
        method = clazz2.getMethod("setIndenting", Boolean.TYPE);
        method.invoke(obj2, Boolean.TRUE);
        method = clazz2.getMethod("setLineWidth", Integer.TYPE);
        method.invoke(obj2, new Integer(0));
        method = clazz2.getMethod("setLineSeparator", String.class);
        method.invoke(obj2, (Object[])new String[]{System.getProperty("line.separator")});
        Method method2 = clazz.getMethod("setOutputByteStream", OutputStream.class);
        method2.invoke(obj, outputStream);
        Method method3 = clazz2.getMethod("setEncoding", String.class);
        method3.invoke(obj2, string);
        Method method4 = clazz.getMethod("setOutputFormat", clazz2);
        method4.invoke(obj, obj2);
        Method method5 = clazz.getMethod("setNamespaces", Boolean.TYPE);
        method5.invoke(obj, Boolean.TRUE);
        Method method6 = clazz.getMethod("asDOMSerializer", new Class[0]);
        Object object = method6.invoke(obj, new Object[0]);
        Method method7 = object.getClass().getMethod("serialize", Document.class);
        method7.invoke(object, document);
    }

    private static void writeJaxp(Document document, OutputStream outputStream, String string) throws IllegalArgumentException, Exception {
        Object object;
        if (XMLUtilImpl.hasNamespaces(document) && System.getProperty("java.version").startsWith("1.4.")) {
            throw new IllegalArgumentException("Writing namespaces using JAXP does not work reliably on JDK 1.4; make sure Xerces is loaded; cf. http://www.netbeans.org/issues/show_bug.cgi?id=51945");
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DocumentType documentType = document.getDoctype();
        if (documentType != null) {
            object = documentType.getPublicId();
            if (object != null) {
                transformer.setOutputProperty("doctype-public", (String)object);
            }
            transformer.setOutputProperty("doctype-system", documentType.getSystemId());
        }
        transformer.setOutputProperty("encoding", string);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        object = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        transformer.transform((Source)object, streamResult);
    }

    private static void writeXalan(Document document, OutputStream outputStream, String string) throws Exception {
        Properties properties = new Properties();
        properties.setProperty("encoding", string);
        properties.setProperty("indent", "yes");
        properties.setProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        properties.setProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Object obj = Class.forName("org.apache.xalan.serialize.SerializerToXML").newInstance();
        Method method = obj.getClass().getMethod("setOutputFormat", Properties.class);
        method.invoke(obj, properties);
        Method method2 = obj.getClass().getMethod("setOutputStream", OutputStream.class);
        method2.invoke(obj, outputStream);
        Method method3 = obj.getClass().getMethod("asDOMSerializer", null);
        Object object = method3.invoke(obj, null);
        Method method4 = object.getClass().getMethod("serialize", Node.class);
        method4.invoke(object, document);
    }

    private static boolean hasNamespaces(Document document) {
        NodeList nodeList = document.getElementsByTagName("*");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (((Element)nodeList.item(i)).getNamespaceURI() == null) continue;
            return true;
        }
        return false;
    }
}

