/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.cartridges.spring.metafacades;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.andromda.cartridges.spring.SpringProfile;
import org.andromda.cartridges.spring.metafacades.SpringMetafacadeUtils;
import org.andromda.cartridges.spring.metafacades.SpringServiceLogic;
import org.andromda.cartridges.spring.metafacades.SpringServiceOperation;
import org.andromda.metafacades.uml.ClassifierFacade;
import org.andromda.metafacades.uml.FilteredCollection;
import org.andromda.metafacades.uml.OperationFacade;
import org.andromda.metafacades.uml.UMLProfile;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public class SpringServiceLogicImpl
extends SpringServiceLogic {
    private static final long serialVersionUID = 34L;
    private static final String HIBERNATE_INTERCEPTOR_ENABLED = "serviceHibernateInterceptorEnabled";
    private static final String EJB_VIEW_TYPE = "ejbViewType";
    private static final String EJB_REMOTE_VIEW = "remote";
    private static final String EJB_LOCAL_VIEW = "local";
    private static final String EJB_BOTH_VIEW = "both";

    public SpringServiceLogicImpl(Object metaObject, String context) {
        super(metaObject, context);
    }

    @Override
    protected String handleGetEjbJndiName() {
        StringBuilder jndiName = new StringBuilder();
        String jndiNamePrefix = StringUtils.trimToEmpty((String)this.getEjbJndiNamePrefix());
        if (StringUtils.isNotBlank((String)jndiNamePrefix)) {
            jndiName.append(jndiNamePrefix);
            jndiName.append('/');
        }
        jndiName.append("ejb/");
        jndiName.append(this.getFullyQualifiedName());
        return jndiName.toString();
    }

    @Override
    protected String handleGetEjbLocalJndiName() {
        StringBuilder jndiName = new StringBuilder();
        String jndiNamePrefix = StringUtils.trimToEmpty((String)this.getEjbJndiNamePrefix());
        if (StringUtils.isNotBlank((String)jndiNamePrefix)) {
            jndiName.append(jndiNamePrefix);
            jndiName.append('/');
        }
        jndiName.append("ejb/");
        jndiName.append(SpringMetafacadeUtils.getFullyQualifiedName(this.getPackageName(), this.getName(), EJB_BOTH_VIEW.equalsIgnoreCase(this.getEjbViewType()) ? "Local" : null));
        return jndiName.toString();
    }

    @Override
    protected String handleGetEjbImplementationName() {
        return this.getName() + "Bean";
    }

    @Override
    protected String handleGetImplementationName() {
        return this.getName() + "Impl";
    }

    @Override
    protected String handleGetFullyQualifiedEjbImplementationName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getEjbPackageName(), this.getName(), "Bean");
    }

    @Override
    protected String handleGetFullyQualifiedEjbName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getEjbPackageName(), this.getName(), null);
    }

    @Override
    protected String handleGetFullyQualifiedLocalEjbName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getEjbPackageName(), this.getName(), EJB_BOTH_VIEW.equalsIgnoreCase(this.getEjbViewType()) ? "Local" : null);
    }

    @Override
    protected String handleGetFullyQualifiedImplementationName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getImplementationPackageName(), this.getName(), "Impl");
    }

    @Override
    protected String handleGetImplementationPackageName() {
        String implementationPackageName = MessageFormat.format(this.getImplemenationPackageNamePattern(), StringUtils.trimToEmpty((String)this.getPackageName()));
        if (StringUtils.isBlank((String)this.getPackageName())) {
            implementationPackageName = implementationPackageName.replaceAll("^\\.", "");
        }
        return implementationPackageName;
    }

    @Override
    protected String handleGetImplementationPackagePath() {
        return this.getImplementationPackageName().replace('.', '/');
    }

    protected String getImplemenationPackageNamePattern() {
        return (String)this.getConfiguredProperty("implementationPackageNamePattern");
    }

    @Override
    protected String handleGetBaseName() {
        return this.getName() + "Base";
    }

    @Override
    protected String handleGetFullyQualifiedBaseName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getImplementationPackageName(), this.getName(), "Base");
    }

    @Override
    protected String handleGetEjbPackageName() {
        String ejbPackageName = MessageFormat.format(this.getEjbPackageNamePattern(), StringUtils.trimToEmpty((String)this.getPackageName()));
        if (StringUtils.isBlank((String)this.getPackageName())) {
            ejbPackageName = ejbPackageName.replaceAll("^\\.", "");
        }
        return ejbPackageName;
    }

    @Override
    protected String handleGetEjbPackageNamePath() {
        return this.getEjbPackageName().replace('.', '/');
    }

    @Override
    protected String handleGetBeanName() {
        return this.getBeanName(false);
    }

    @Override
    protected String handleGetBeanName(boolean targetSuffix) {
        StringBuilder beanName = new StringBuilder(String.valueOf(this.getConfiguredProperty("beanNamePrefix")));
        beanName.append(StringUtils.uncapitalize((String)StringUtils.trimToEmpty((String)this.getName())));
        if (targetSuffix) {
            beanName.append("Target");
        }
        return beanName.toString();
    }

    protected String getEjbPackageNamePattern() {
        return (String)this.getConfiguredProperty("ejbPackageNamePattern");
    }

    protected String getEjbJndiNamePrefix() {
        return this.isConfiguredProperty("ejbJndiNamePrefix") ? ObjectUtils.toString((Object)this.getConfiguredProperty("ejbJndiNamePrefix")) : null;
    }

    @Override
    protected String handleGetWebServiceDelegatorName() {
        return this.getName() + "WSDelegator";
    }

    @Override
    protected String handleGetFullyQualifiedWebServiceDelegatorName() {
        return SpringMetafacadeUtils.getFullyQualifiedName(this.getImplementationPackageName(), this.getName(), "WSDelegator");
    }

    @Override
    protected boolean handleIsWebService() {
        boolean webService = this.hasStereotype(UMLProfile.STEREOTYPE_WEBSERVICE);
        if (!webService) {
            webService = !this.getWebServiceOperations().isEmpty();
        }
        return webService;
    }

    @Override
    protected Collection<String> handleGetInterceptors() {
        String serviceInterceptorString = this.isConfiguredProperty("serviceInterceptors") ? ObjectUtils.toString((Object)this.getConfiguredProperty("serviceInterceptors")) : null;
        List<String> interceptors = null;
        if (StringUtils.isNotBlank((String)serviceInterceptorString)) {
            interceptors = Arrays.asList(serviceInterceptorString.split(","));
        }
        return SpringMetafacadeUtils.getServiceInterceptors((ClassifierFacade)this, interceptors);
    }

    @Override
    protected boolean handleIsRemotable() {
        return !this.isPrivate() && !this.isRemotingTypeNone();
    }

    private String getRemotingType() {
        String serviceRemotingType = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemotingType")));
        return SpringMetafacadeUtils.getServiceRemotingType((ClassifierFacade)this, serviceRemotingType);
    }

    @Override
    protected String handleGetRemoteServer() {
        return StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemoteServer")));
    }

    @Override
    protected String handleGetRemotePort() {
        String serviceRemotePort = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("serviceRemotePort")));
        return SpringMetafacadeUtils.getServiceRemotePort((ClassifierFacade)this, serviceRemotePort);
    }

    @Override
    protected String handleGetRemoteContext() {
        return this.isConfiguredProperty("serviceRemoteContext") ? ObjectUtils.toString((Object)this.getConfiguredProperty("serviceRemoteContext")) : "";
    }

    private boolean hasServiceRemotePort() {
        String serviceRemotePort = this.getRemotePort();
        return StringUtils.isNotBlank((String)serviceRemotePort);
    }

    private boolean hasServiceRemoteContext() {
        String serviceRemoteContext = this.getRemoteContext();
        return StringUtils.isNotBlank((String)serviceRemoteContext);
    }

    @Override
    protected String handleGetRemoteUrl() {
        String result = "";
        String propertyPrefix = ObjectUtils.toString((Object)this.getConfiguredProperty("configPropertyPrefix"));
        if (!this.isRemotingTypeNone()) {
            if (this.isRemotingTypeHttpInvoker() || this.isRemotingTypeHessian() || this.isRemotingTypeBurlap()) {
                result = "${" + propertyPrefix + "remoteHttpScheme}://${" + propertyPrefix + "remoteServer}";
                if (this.hasServiceRemotePort()) {
                    result = result + ":${" + propertyPrefix + "remotePort}";
                }
                if (this.hasServiceRemoteContext()) {
                    result = result + "/${" + propertyPrefix + "remoteContext}";
                }
                result = result + '/' + this.getName();
            } else if (this.isRemotingTypeLingo()) {
                result = "${" + propertyPrefix + "remoteTcpScheme}://${" + propertyPrefix + "remoteServer}";
                result = result + "/${" + propertyPrefix + "remotePortJMS}";
            } else if (this.isRemotingTypeRmi()) {
                result = "${" + propertyPrefix + "remoteRmiScheme}://${" + propertyPrefix + "remoteServer}";
                if (this.hasServiceRemotePort()) {
                    result = result + ":${" + propertyPrefix + "remotePort}";
                }
                result = result + '/' + this.getName();
            }
        }
        return result;
    }

    @Override
    protected Collection handleGetWebServiceOperations() {
        List<Object> operations = this.getOperations();
        if (!this.hasStereotype(UMLProfile.STEREOTYPE_WEBSERVICE)) {
            operations = new FilteredCollection(operations){
                private static final long serialVersionUID = 34L;

                public boolean evaluate(Object object) {
                    return object instanceof SpringServiceOperation && ((SpringServiceOperation)object).isWebserviceExposed();
                }
            };
        }
        return operations;
    }

    @Override
    public List<OperationFacade> getOperations() {
        final List<OperationFacade> operations = super.getOperations();
        if (!this.isAbstract()) {
            for (ClassifierFacade generalization = (ClassifierFacade)this.getGeneralization(); generalization != null; generalization = (ClassifierFacade)generalization.getGeneralization()) {
                if (!generalization.isAbstract()) continue;
                CollectionUtils.forAllDo((Collection)generalization.getOperations(), (Closure)new Closure(){

                    public void execute(Object object) {
                        if (((OperationFacade)object).isAbstract()) {
                            operations.add((OperationFacade)object);
                        }
                    }
                });
            }
        }
        return operations;
    }

    @Override
    protected String handleGetDefaultExceptionName() {
        String name = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("defaultServiceExceptionNamePattern")));
        return name.replaceAll("\\{0\\}", this.getName());
    }

    @Override
    protected String handleGetFullyQualifiedDefaultExceptionName() {
        StringBuilder fullyQualifiedName = new StringBuilder("RuntimeException");
        if (this.isAllowDefaultServiceException()) {
            fullyQualifiedName = new StringBuilder();
            if (StringUtils.isNotBlank((String)this.getPackageName())) {
                fullyQualifiedName.append(this.getPackageName());
                fullyQualifiedName.append('.');
            }
            fullyQualifiedName.append(this.getDefaultExceptionName());
        }
        return fullyQualifiedName.toString();
    }

    @Override
    protected boolean handleIsAllowDefaultServiceException() {
        return Boolean.valueOf(String.valueOf(this.getConfiguredProperty("defaultServiceExceptions")));
    }

    @Override
    protected boolean handleIsRemotingTypeRmi() {
        return "rmi".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeBurlap() {
        return "burlap".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeHessian() {
        return "hessian".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeHttpInvoker() {
        return "httpinvoker".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeLingo() {
        return "lingo".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsRemotingTypeNone() {
        return "none".equalsIgnoreCase(this.getRemotingType());
    }

    @Override
    protected boolean handleIsHibernateInterceptorEnabled() {
        return Boolean.valueOf(String.valueOf(this.getConfiguredProperty(HIBERNATE_INTERCEPTOR_ENABLED)));
    }

    private String getEjbViewType() {
        Object value = this.findTaggedValue(SpringProfile.TAGGEDVALUE_EJB_VIEW_TYPE);
        if (value == null) {
            value = this.getConfiguredProperty(EJB_VIEW_TYPE);
        }
        return ObjectUtils.toString((Object)value);
    }

    @Override
    protected boolean handleIsEjbRemoteView() {
        return EJB_REMOTE_VIEW.equalsIgnoreCase(this.getEjbViewType()) || EJB_BOTH_VIEW.equalsIgnoreCase(this.getEjbViewType());
    }

    @Override
    protected boolean handleIsEjbLocalView() {
        return EJB_LOCAL_VIEW.equalsIgnoreCase(this.getEjbViewType()) || EJB_BOTH_VIEW.equalsIgnoreCase(this.getEjbViewType());
    }

    @Override
    protected String handleGetEjbTransactionType() {
        String transactionType = null;
        boolean ejbTransactionsEnabled = BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)this.getConfiguredProperty("ejbTransactionsEnabled")));
        transactionType = ejbTransactionsEnabled ? "Container" : "Bean";
        return transactionType;
    }

    @Override
    protected boolean handleIsConfigonly() {
        String value = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_SERVICE_CONFIG_ONLY);
        return BooleanUtils.toBoolean((String)StringUtils.trimToEmpty((String)value));
    }

    @Override
    protected boolean handleIsPrivate() {
        String value = (String)this.findTaggedValue(SpringProfile.TAGGEDVALUE_SERVICE_PRIVATE);
        return BooleanUtils.toBoolean((String)StringUtils.trimToEmpty((String)value));
    }

    @Override
    protected String handleGetWebServiceOutgoingAttachmentHandlerCall() {
        return this.getWebServiceAttachmentHandlerCall("webServiceOutgoingAttachmentHandlerCallPattern");
    }

    @Override
    protected String handleGetWebServiceIncomingAttachmentHandlerCall() {
        return this.getWebServiceAttachmentHandlerCall("webServiceIncomingAttachmentHandlerCallPattern");
    }

    private String getWebServiceAttachmentHandlerCall(String patternProperty) {
        String value;
        String call = null;
        if (this.isWebService() && StringUtils.isNotBlank((String)(value = ObjectUtils.toString((Object)this.getConfiguredProperty(patternProperty))))) {
            call = value;
        }
        return call;
    }

    @Override
    protected boolean handleIsRichClient() {
        String richClient = StringUtils.trimToEmpty((String)String.valueOf(this.getConfiguredProperty("richClient")));
        return "true".equalsIgnoreCase(richClient);
    }

    @Override
    protected String handleGetInitMethodName() {
        String result = "";
        for (OperationFacade operation : this.getOperations()) {
            if (!((SpringServiceOperation)operation).isInitMethod()) continue;
            result = operation.getName();
            break;
        }
        return result;
    }

    @Override
    protected String handleGetDestroyMethodName() {
        String result = "";
        for (OperationFacade operation : this.getOperations()) {
            if (!((SpringServiceOperation)operation).isDestroyMethod()) continue;
            result = operation.getName();
            break;
        }
        return result;
    }
}

