/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.filesys.db;

import org.alfresco.jlan.server.filesys.FileInfo;
import org.alfresco.jlan.server.filesys.SearchContext;
import org.alfresco.jlan.server.filesys.db.DBFileInfo;

public class CachedSearchContext
extends SearchContext {
    private DBFileInfo m_info;

    public CachedSearchContext(DBFileInfo finfo) {
        this.m_info = finfo;
    }

    @Override
    public int getResumeId() {
        return -1;
    }

    @Override
    public boolean hasMoreFiles() {
        return this.m_info != null;
    }

    @Override
    public boolean nextFileInfo(FileInfo info) {
        boolean infoValid = false;
        if (this.m_info != null) {
            info.setFileId(this.m_info.getFileId());
            info.setDirectoryId(this.m_info.getDirectoryId());
            info.setFileName(this.m_info.getFileName());
            info.setFileAttributes(this.m_info.getFileAttributes());
            info.setSize(this.m_info.getSize());
            info.setAllocationSize(this.m_info.getAllocationSize());
            info.setCreationDateTime(this.m_info.getCreationDateTime());
            info.setAccessDateTime(this.m_info.getAccessDateTime());
            info.setModifyDateTime(this.m_info.getModifyDateTime());
            info.setChangeDateTime(this.m_info.getChangeDateTime());
            info.setUid(this.m_info.getUid());
            info.setGid(this.m_info.getGid());
            info.setMode(this.m_info.getMode());
            this.m_info = null;
            infoValid = true;
        }
        return infoValid;
    }

    @Override
    public String nextFileName() {
        return this.m_info != null ? this.m_info.getFileName() : null;
    }

    @Override
    public boolean restartAt(int resumeId) {
        return false;
    }

    @Override
    public boolean restartAt(FileInfo info) {
        return false;
    }
}

