/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.ntlm;

import java.io.Serializable;
import java.util.Date;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;

public class NTLMLogonDetails
implements Serializable {
    private String m_user;
    private String m_workstation;
    private String m_domain;
    private String m_authSrvAddr;
    private long m_authTime;
    private boolean m_guestAccess;
    private Type2NTLMMessage m_type2Msg;
    private byte[] m_ntlmHash;
    private Object m_authToken;

    public NTLMLogonDetails() {
    }

    public NTLMLogonDetails(String user, String wks, String domain, boolean guest, String authSrv) {
        this.setDetails(user, wks, domain, guest, authSrv);
    }

    public final String getUserName() {
        return this.m_user;
    }

    public final String getWorkstation() {
        return this.m_workstation;
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final String getAuthenticationServer() {
        return this.m_authSrvAddr;
    }

    public final long authenticatedAt() {
        return this.m_authTime;
    }

    public final boolean hasType2Message() {
        return this.m_type2Msg != null;
    }

    public final Type2NTLMMessage getType2Message() {
        return this.m_type2Msg;
    }

    public final boolean hasNTLMHashedPassword() {
        return this.m_ntlmHash != null;
    }

    public final byte[] getNTLMHashedPassword() {
        return this.m_ntlmHash;
    }

    public final byte[] getChallengeKey() {
        if (this.m_type2Msg != null) {
            return this.m_type2Msg.getChallenge();
        }
        return null;
    }

    public final boolean hasAuthenticationToken() {
        return this.m_authToken != null;
    }

    public final Object getAuthenticationToken() {
        return this.m_authToken;
    }

    public final void setAuthenticationToken(Object token) {
        this.m_authToken = token;
    }

    public final void setAuthenticatedAt(long authTime) {
        this.m_authTime = authTime;
    }

    public final void setDetails(String user, String wks, String domain, boolean guest, String authSrv) {
        this.m_user = user;
        this.m_workstation = wks;
        this.m_domain = domain;
        this.m_authSrvAddr = authSrv;
        this.m_guestAccess = guest;
        this.m_authTime = System.currentTimeMillis();
    }

    public final void setType2Message(Type2NTLMMessage type2) {
        this.m_type2Msg = type2;
    }

    public final void setNTLMHashedPassword(byte[] ntlmHash) {
        this.m_ntlmHash = ntlmHash;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(this.getUserName());
        str.append(",Wks:");
        str.append(this.getWorkstation());
        str.append(",Dom:");
        str.append(this.getDomain());
        str.append(",AuthSrv:");
        str.append(this.getAuthenticationServer());
        str.append(",");
        str.append(new Date(this.authenticatedAt()));
        str.append("]");
        return str.toString();
    }
}

