/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client.admin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.jlan.client.IPCSession;
import org.alfresco.jlan.client.admin.IPCPipeFile;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.smb.dcerpc.DCEBuffer;
import org.alfresco.jlan.smb.dcerpc.DCEBufferException;
import org.alfresco.jlan.smb.dcerpc.client.DCEPacket;
import org.alfresco.jlan.smb.dcerpc.info.RegistryKey;
import org.alfresco.jlan.smb.dcerpc.info.RegistryKeyInfo;
import org.alfresco.jlan.smb.dcerpc.info.RegistryValue;

public class WinregPipeFile
extends IPCPipeFile {
    private static final int MaxReturnBufferSize = 0x100000;

    public WinregPipeFile(IPCSession sess, DCEPacket pkt, int handle, String name, int maxTx, int maxRx) {
        super(sess, pkt, handle, name, maxTx, maxRx);
    }

    public final RegistryKey openHKLocalMachine() throws IOException, SMBException {
        return this.openRootKey(0);
    }

    public final RegistryKey openHKUsers() throws IOException, SMBException {
        return this.openRootKey(3);
    }

    public final RegistryKey openHKClassesRoot() throws IOException, SMBException {
        return this.openRootKey(1);
    }

    public final RegistryKey openHKCurrentUser() throws IOException, SMBException {
        return this.openRootKey(2);
    }

    public final RegistryKey openHKPerformanceData() throws IOException, SMBException {
        return this.openRootKey(4);
    }

    public final RegistryKey openKey(RegistryKey root, String key) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(root);
        buf.putUnicodeHeader(key, true);
        buf.putString(key, 1, true);
        buf.putZeroInts(1);
        buf.putInt(0x2000000);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 15, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        RegistryKey regKey = new RegistryKey(key, root);
        try {
            this.checkStatus(buf.getStatusCode());
            buf.getHandle(regKey);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return regKey;
    }

    public final RegistryKey openKey(RegistryKey root, RegistryKey key) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(root);
        buf.putUnicodeHeader(key.getName(), true);
        buf.putString(key.getName(), 1, true);
        buf.putZeroInts(1);
        buf.putInt(0x2000000);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 15, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getStatusCode());
            buf.getHandle(key);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return key;
    }

    public final void closeHandle(RegistryKey handle) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 5, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getInt());
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        handle.markClosed();
    }

    public final RegistryKeyInfo getKeyInfo(RegistryKey handle, String cls) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(handle);
        buf.putUnicodeHeader(cls, true);
        buf.putString(cls != null ? cls : "", 1, true);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 16, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        RegistryKeyInfo keyInfo = new RegistryKeyInfo();
        try {
            this.checkStatus(buf.getStatusCode());
            keyInfo.readObject(buf);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return keyInfo;
    }

    public final RegistryValue getValue(RegistryKey key, String name) throws IOException, SMBException {
        RegistryValue regVal = new RegistryValue(name);
        return this.getValue(key, regVal);
    }

    public final RegistryValue getValue(RegistryKey key, RegistryValue regval) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        String name = regval.getName();
        buf.putHandle(key);
        buf.putUnicodeHeader(name, true);
        buf.putString(name != null ? name : "", 1, true);
        buf.putPointer(true);
        buf.putPointer(true);
        buf.putPointer(true);
        buf.putInt(0x100000);
        buf.putPointer(false);
        buf.putInt(0);
        buf.putPointer(true);
        buf.putInt(0x100000);
        buf.putPointer(true);
        buf.putInt(0);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 17, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getStatusCode());
            regval.readValue(buf);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return regval;
    }

    public final RegistryValue getDefaultValue(RegistryKey key) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(key);
        buf.putShort(2);
        buf.putShort(2);
        buf.putPointer(true);
        buf.putInt(1);
        buf.putInt(0);
        buf.putInt(1);
        buf.putInt(0);
        buf.putPointer(true);
        buf.putPointer(true);
        buf.putPointer(true);
        buf.putInt(0x100000);
        buf.putPointer(false);
        buf.putInt(0);
        buf.putPointer(true);
        buf.putInt(0x100000);
        buf.putPointer(true);
        buf.putInt(0);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 17, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        RegistryValue regVal = new RegistryValue("(Default)");
        try {
            this.checkStatus(buf.getStatusCode());
            regVal.readValue(buf);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return regVal;
    }

    public final List<RegistryValue> getValuesForKey(RegistryKey key) throws IOException, SMBException {
        RegistryKeyInfo keyInfo = this.getKeyInfo(key, null);
        ArrayList<RegistryValue> regValues = new ArrayList<RegistryValue>();
        if (keyInfo.getNumberOfValues() > 0) {
            int valIdx = 0;
            while (valIdx < keyInfo.getNumberOfValues()) {
                DCEBuffer buf = this.getBuffer();
                buf.resetBuffer();
                buf.putHandle(key);
                buf.putInt(valIdx++);
                buf.putUnicodeReturn(512);
                buf.putStringReturn(256, 1);
                buf.putPointer(true);
                buf.putInt(0);
                buf.putPointer(true);
                buf.putInt(keyInfo.getMaximumValueNameLength());
                buf.putPointer(true);
                buf.putInt(keyInfo.getMaximumValueLength());
                DCEPacket pkt = this.getPacket();
                try {
                    pkt.initializeDCERequest(this.getHandle(), 10, buf, this.getMaximumTransmitSize(), this.getNextCallId());
                }
                catch (DCEBufferException ex) {
                    ex.printStackTrace();
                }
                this.doDCERequest(pkt);
                buf = this.getRxBuffer();
                RegistryValue regVal = new RegistryValue();
                try {
                    this.checkStatus(buf.getStatusCode());
                    regVal.readObject(buf);
                    if (regVal.getName() == null || regVal.getName().length() <= 0) continue;
                    this.getValue(key, regVal);
                    regValues.add(regVal);
                }
                catch (DCEBufferException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return regValues;
    }

    public final List<RegistryKey> getKeysForKey(RegistryKey parentKey) throws IOException, SMBException {
        RegistryKeyInfo keyInfo = this.getKeyInfo(parentKey, null);
        ArrayList<RegistryKey> regKeys = new ArrayList<RegistryKey>();
        RegistryKey lastChild = null;
        if (keyInfo.getNumberOfSubkeys() > 0) {
            int keyIdx = 0;
            while (keyIdx < keyInfo.getNumberOfSubkeys()) {
                DCEBuffer buf = this.getBuffer();
                buf.resetBuffer();
                buf.putHandle(parentKey);
                buf.putInt(keyIdx++);
                buf.putUnicodeReturn(512);
                buf.putStringReturn(256, 1);
                buf.putPointer(false);
                buf.putPointer(false);
                buf.putPointer(false);
                DCEPacket pkt = this.getPacket();
                try {
                    pkt.initializeDCERequest(this.getHandle(), 9, buf, this.getMaximumTransmitSize(), this.getNextCallId());
                }
                catch (DCEBufferException ex) {
                    ex.printStackTrace();
                }
                this.doDCERequest(pkt);
                buf = this.getRxBuffer();
                RegistryKey regKey = new RegistryKey(parentKey);
                try {
                    this.checkStatus(buf.getStatusCode());
                    regKey.readObject(buf);
                }
                catch (DCEBufferException ex) {
                    ex.printStackTrace();
                }
                if (!parentKey.hasChild()) {
                    parentKey.setChild(regKey);
                }
                if (lastChild != null) {
                    lastChild.setSibling(regKey);
                }
                lastChild = regKey;
                regKeys.add(regKey);
            }
        }
        return regKeys;
    }

    public final RegistryKey createKey(RegistryKey parent, String keyName) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(parent);
        buf.putUnicodeHeader(keyName, true);
        buf.putString(keyName, 1, true);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0);
        buf.putInt(0x10000000);
        buf.putInt(0);
        buf.putInt(0);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 6, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        RegistryKey key = new RegistryKey(keyName, parent);
        try {
            this.checkStatus(buf.getStatusCode());
            buf.getHandle(key);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return key;
    }

    public final void deleteKey(RegistryKey parent, String keyName) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(parent);
        buf.putUnicodeHeader(keyName, true);
        buf.putString(keyName, 1, true);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 7, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getInt());
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
    }

    public final void createValue(RegistryKey parent, RegistryValue value) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(parent);
        buf.putUnicodeHeader(value.getName(), true);
        buf.putString(value.getName(), 1, true);
        buf.putInt(value.getDataType());
        if (value.getRawValue() != null) {
            int len = value.getRawValue().length;
            buf.putInt(len);
            buf.putBytes(value.getRawValue(), len, 1);
            buf.putInt(len);
        } else {
            buf.putInt(0);
            buf.putInt(0);
        }
        try {
            this.doDCERequest(22, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getInt());
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
    }

    public final void deleteValue(RegistryKey parent, String valueName) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putHandle(parent);
        buf.putUnicodeHeader(valueName, true);
        buf.putString(valueName, 1, true);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 8, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getInt());
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
    }

    public final void shutdownServer(String msg, int tmo, boolean reboot, boolean force) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putPointer(true);
        buf.putPointer(true);
        buf.putUnicodeHeader(msg, false);
        buf.putString(msg, 1, false);
        buf.putInt(tmo);
        buf.putByte(force ? 1 : 0);
        buf.putByte(reboot ? 1 : 0);
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), 24, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        try {
            this.checkStatus(buf.getInt());
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
    }

    public final RegistryKey openRootKey(int keyid) throws IOException, SMBException {
        DCEBuffer buf = this.getBuffer();
        buf.resetBuffer();
        buf.putPointer(true);
        buf.putShort(34016);
        buf.putShort(0);
        buf.putInt(0x2000000);
        int opCode = -1;
        String name = null;
        switch (keyid) {
            case 1: {
                opCode = 0;
                name = "HKEY_CLASSES_ROOT";
                break;
            }
            case 0: {
                opCode = 2;
                name = "HKEY_LOCAL_MACHINE";
                break;
            }
            case 2: {
                opCode = 1;
                name = "HKEY_CURRENT_USER";
                break;
            }
            case 3: {
                opCode = 4;
                name = "HKEY_USERS";
                break;
            }
            case 4: {
                opCode = 3;
                name = "HKEY_PERFORMANCE_DATA";
            }
        }
        if (opCode == -1) {
            return null;
        }
        DCEPacket pkt = this.getPacket();
        try {
            pkt.initializeDCERequest(this.getHandle(), opCode, buf, this.getMaximumTransmitSize(), this.getNextCallId());
        }
        catch (DCEBufferException ex) {
            ex.printStackTrace();
        }
        this.doDCERequest(pkt);
        buf = this.getRxBuffer();
        RegistryKey regKey = new RegistryKey(name);
        try {
            this.checkStatus(buf.getStatusCode());
            buf.getHandle(regKey);
        }
        catch (DCEBufferException ex) {
            // empty catch block
        }
        return regKey;
    }
}

