/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.ast;

import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.SemanticErrorReporter;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAccess;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimensions;
import net.sourceforge.pmd.lang.java.ast.ASTArrayInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTCastExpression;
import net.sourceforge.pmd.lang.java.ast.ASTCharLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTInfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTMethodReference;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTNumericLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPattern;
import net.sourceforge.pmd.lang.java.ast.ASTPatternExpression;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTSuperExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTTemplateExpression;
import net.sourceforge.pmd.lang.java.ast.ASTThisExpression;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypeParameter;
import net.sourceforge.pmd.lang.java.ast.ASTTypePattern;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.ASTVoidType;
import net.sourceforge.pmd.lang.java.ast.BinaryOp;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.internal.JavaAstProcessor;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JLocalVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.NameResolver;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import net.sourceforge.pmd.lang.java.types.Substitution;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.TypesFromReflection;
import net.sourceforge.pmd.lang.java.types.TypingContext;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import net.sourceforge.pmd.lang.java.types.ast.PolyResolution;
import net.sourceforge.pmd.lang.java.types.internal.infer.Infer;
import net.sourceforge.pmd.lang.java.types.internal.infer.TypeInferenceLogger;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@InternalApi
public final class LazyTypeResolver
extends JavaVisitorBase<TypingContext, JTypeMirror> {
    private final TypeSystem ts;
    private final PolyResolution polyResolution;
    private final JClassType stringType;
    private final JavaAstProcessor processor;
    private final SemanticErrorReporter err;
    private final Infer infer;

    public LazyTypeResolver(JavaAstProcessor processor, TypeInferenceLogger logger) {
        this.ts = processor.getTypeSystem();
        this.infer = new Infer(this.ts, processor.getJdkVersion(), logger);
        this.polyResolution = new PolyResolution(this.infer);
        this.stringType = (JClassType)TypesFromReflection.fromReflect(String.class, this.ts);
        this.processor = processor;
        this.err = processor.getLogger();
    }

    public ExprContext getConversionContextForExternalUse(ASTExpression e) {
        return this.polyResolution.getConversionContextForExternalUse(e);
    }

    public ExprContext getTopLevelContextIncludingInvocation(TypeNode e) {
        ExprContext surrounding;
        ExprContext toplevel = this.polyResolution.getTopLevelConversionContext(e);
        while (toplevel.hasKind(ExprContext.ExprContextKind.INVOCATION) && !(surrounding = this.polyResolution.getTopLevelConversionContext(toplevel.getInvocNodeIfInvocContext())).isMissing()) {
            toplevel = surrounding;
        }
        return toplevel;
    }

    public Infer getInfer() {
        return this.infer;
    }

    public JavaAstProcessor getProcessor() {
        return this.processor;
    }

    public TypeSystem getTypeSystem() {
        return this.ts;
    }

    @Override
    public JTypeMirror visitJavaNode(JavaNode node, TypingContext ctx) {
        throw new IllegalArgumentException("Not a type node:" + node);
    }

    @Override
    public JTypeMirror visit(ASTFormalParameter node, TypingContext ctx) {
        return node.getVarId().getTypeMirror(ctx);
    }

    @Override
    public JTypeMirror visit(ASTTypeParameter node, TypingContext ctx) {
        return ((JTypeParameterSymbol)node.getSymbol()).getTypeMirror();
    }

    @Override
    public JTypeMirror visitTypeDecl(ASTAnyTypeDeclaration node, TypingContext ctx) {
        return this.ts.declaration(node.getSymbol());
    }

    @Override
    public JTypeMirror visit(ASTAnnotation node, TypingContext ctx) {
        return node.getTypeNode().getTypeMirror(ctx);
    }

    @Override
    public JTypeMirror visitType(ASTType node, TypingContext ctx) {
        return InternalApiBridge.buildTypeFromAstInternal(this.ts, Substitution.EMPTY, node);
    }

    @Override
    public JTypeMirror visit(ASTVoidType node, TypingContext ctx) {
        return this.ts.NO_TYPE;
    }

    @Override
    public JTypeMirror visit(ASTVariableDeclaratorId node, TypingContext ctx) {
        boolean isTypeInferred = node.isTypeInferred();
        if (isTypeInferred && node.getInitializer() != null) {
            ASTExpression initializer = node.getInitializer();
            return initializer == null ? this.ts.ERROR : TypeOps.projectUpwards(initializer.getTypeMirror(ctx));
        }
        if (isTypeInferred && node.isForeachVariable()) {
            ASTForeachStatement foreachStmt = (ASTForeachStatement)node.ancestors(ASTForeachStatement.class).firstOrThrow();
            JTypeMirror iterableType = foreachStmt.getIterableExpr().getTypeMirror(ctx);
            if ((iterableType = TypeConversion.capture(iterableType)) instanceof JArrayType) {
                return ((JArrayType)iterableType).getComponentType();
            }
            JTypeMirror asSuper = iterableType.getAsSuper(this.ts.getClassSymbol(Iterable.class));
            if (asSuper instanceof JClassType) {
                if (asSuper.isRaw()) {
                    return this.ts.OBJECT;
                }
                JTypeMirror componentType = ((JClassType)asSuper).getTypeArgs().get(0);
                return TypeOps.projectUpwards(componentType);
            }
            return this.ts.ERROR;
        }
        if (isTypeInferred && node.isLambdaParameter()) {
            ASTLambdaParameter param = (ASTLambdaParameter)node.getParent();
            ASTLambdaExpression lambda = (ASTLambdaExpression)node.getNthParent(3);
            JTypeMirror contextualResult = ctx.apply((JVariableSymbol)node.getSymbol());
            if (contextualResult != null) {
                return contextualResult;
            }
            JMethodSig mirror = lambda.getFunctionalMethod();
            if (this.isUnresolved(mirror)) {
                return this.ts.UNKNOWN;
            }
            return mirror.getFormalParameters().get(param.getIndexInParent());
        }
        if (node.isEnumConstant()) {
            ASTAnyTypeDeclaration enumClass = node.getEnclosingType();
            return enumClass.getTypeMirror(ctx);
        }
        ASTType typeNode = node.getTypeNode();
        if (typeNode == null) {
            return this.ts.ERROR;
        }
        JTypeMirror baseType = typeNode.getTypeMirror(ctx);
        ASTArrayDimensions extras = node.getExtraDimensions();
        return extras != null ? this.ts.arrayType(baseType, extras.size()) : baseType;
    }

    @Override
    public JTypeMirror visit(ASTAssignmentExpression node, TypingContext ctx) {
        return TypeConversion.capture(node.getLeftOperand().getTypeMirror(ctx));
    }

    private JTypeMirror handlePoly(TypeNode node) {
        return this.polyResolution.computePolyType(node);
    }

    @Override
    public JTypeMirror visit(ASTMethodCall node, TypingContext ctx) {
        return this.handlePoly(node);
    }

    @Override
    public JTypeMirror visit(ASTConditionalExpression node, TypingContext ctx) {
        return this.handlePoly(node);
    }

    @Override
    public JTypeMirror visit(ASTLambdaExpression node, TypingContext ctx) {
        return this.handlePoly(node);
    }

    @Override
    public JTypeMirror visit(ASTSwitchExpression node, TypingContext ctx) {
        return this.handlePoly(node);
    }

    @Override
    public JTypeMirror visit(ASTMethodReference node, TypingContext ctx) {
        return this.handlePoly(node);
    }

    @Override
    public JTypeMirror visit(ASTConstructorCall node, TypingContext ctx) {
        return this.handlePoly(node);
    }

    @Override
    public JTypeMirror visit(ASTExplicitConstructorInvocation node, TypingContext ctx) {
        return this.handlePoly(node);
    }

    @Override
    public JTypeMirror visit(ASTEnumConstant node, TypingContext ctx) {
        return this.handlePoly(node);
    }

    @Override
    public JTypeMirror visit(ASTInfixExpression node, TypingContext ctx) {
        BinaryOp op = node.getOperator();
        switch (op) {
            case CONDITIONAL_OR: 
            case CONDITIONAL_AND: 
            case EQ: 
            case NE: 
            case LE: 
            case GE: 
            case GT: 
            case INSTANCEOF: 
            case LT: {
                return this.ts.BOOLEAN;
            }
            case OR: 
            case XOR: 
            case AND: {
                JTypeMirror lhs = node.getLeftOperand().getTypeMirror(ctx);
                JTypeMirror rhs = node.getRightOperand().getTypeMirror(ctx);
                if (lhs.isNumeric() && rhs.isNumeric()) {
                    return TypeConversion.binaryNumericPromotion(lhs, rhs);
                }
                if (lhs.equals(rhs)) {
                    return lhs;
                }
                if (this.isUnresolved(lhs) ^ this.isUnresolved(rhs)) {
                    JTypeMirror resolved;
                    JTypeMirror jTypeMirror = resolved = this.isUnresolved(lhs) ? rhs : lhs;
                    return resolved.isNumeric() ? TypeConversion.unaryNumericPromotion(resolved) : (resolved == this.ts.BOOLEAN ? resolved : this.ts.ERROR);
                }
                return this.ts.ERROR;
            }
            case LEFT_SHIFT: 
            case RIGHT_SHIFT: 
            case UNSIGNED_RIGHT_SHIFT: {
                return TypeConversion.unaryNumericPromotion(node.getLeftOperand().getTypeMirror(ctx));
            }
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: {
                JTypeMirror lhs = node.getLeftOperand().getTypeMirror(ctx);
                JTypeMirror rhs = node.getRightOperand().getTypeMirror(ctx);
                if (op == BinaryOp.ADD && (lhs.equals(this.stringType) || rhs.equals(this.stringType))) {
                    return this.stringType;
                }
                if (this.isUnresolved(lhs)) {
                    return rhs;
                }
                if (this.isUnresolved(rhs)) {
                    return lhs;
                }
                return TypeConversion.binaryNumericPromotion(lhs, rhs);
            }
        }
        throw new AssertionError((Object)("Unknown operator for " + node));
    }

    private boolean isUnresolved(JTypeMirror t) {
        return t == this.ts.UNKNOWN;
    }

    private boolean isUnresolved(JMethodSig m) {
        return m == null || m == this.ts.UNRESOLVED_METHOD;
    }

    @Override
    public JTypeMirror visit(ASTUnaryExpression node, TypingContext ctx) {
        switch (node.getOperator()) {
            case UNARY_PLUS: 
            case UNARY_MINUS: 
            case COMPLEMENT: {
                return TypeConversion.unaryNumericPromotion(node.getOperand().getTypeMirror(ctx));
            }
            case NEGATION: {
                return this.ts.BOOLEAN;
            }
            case PRE_INCREMENT: 
            case PRE_DECREMENT: 
            case POST_INCREMENT: 
            case POST_DECREMENT: {
                return node.getOperand().getTypeMirror(ctx);
            }
        }
        throw new AssertionError((Object)("Unknown operator for " + node));
    }

    @Override
    public JTypeMirror visit(ASTPatternExpression node, TypingContext ctx) {
        ASTPattern pattern = node.getPattern();
        if (pattern instanceof ASTTypePattern) {
            return ((ASTTypePattern)pattern).getTypeNode().getTypeMirror(ctx);
        }
        throw new IllegalArgumentException("Unknown pattern " + pattern);
    }

    @Override
    public JTypeMirror visit(ASTCastExpression node, TypingContext ctx) {
        return node.getCastType().getTypeMirror(ctx);
    }

    @Override
    public @NonNull JTypeMirror visit(ASTTemplateExpression node, TypingContext data) {
        if (node.isStringTemplate()) {
            return this.stringType;
        }
        return this.ts.UNKNOWN;
    }

    @Override
    public JTypeMirror visit(ASTNullLiteral node, TypingContext ctx) {
        return this.ts.NULL_TYPE;
    }

    @Override
    public JTypeMirror visit(ASTCharLiteral node, TypingContext ctx) {
        return this.ts.CHAR;
    }

    @Override
    public JTypeMirror visit(ASTStringLiteral node, TypingContext ctx) {
        return this.stringType;
    }

    @Override
    public JTypeMirror visit(ASTNumericLiteral node, TypingContext ctx) {
        if (node.isIntegral()) {
            return node.isLongLiteral() ? this.ts.LONG : this.ts.INT;
        }
        return node.isFloatLiteral() ? this.ts.FLOAT : this.ts.DOUBLE;
    }

    @Override
    public JTypeMirror visit(ASTBooleanLiteral node, TypingContext ctx) {
        return this.ts.BOOLEAN;
    }

    @Override
    public JTypeMirror visit(ASTClassLiteral node, TypingContext ctx) {
        JClassSymbol klassSym = this.ts.getClassSymbol(Class.class);
        assert (klassSym != null) : Class.class + " is missing from the classpath?";
        if (node.getTypeNode() instanceof ASTVoidType) {
            return this.ts.parameterise(klassSym, CollectionUtil.listOf((Object)this.ts.BOXED_VOID, (Object[])new JClassType[0]));
        }
        return this.ts.parameterise(klassSym, CollectionUtil.listOf((Object)node.getTypeNode().getTypeMirror(ctx).box(), (Object[])new JTypeMirror[0]));
    }

    @Override
    public JTypeMirror visit(ASTArrayAllocation node, TypingContext ctx) {
        return node.getTypeNode().getTypeMirror(ctx);
    }

    @Override
    public JTypeMirror visit(ASTArrayInitializer node, TypingContext ctx) {
        JavaNode parent = (JavaNode)node.getParent();
        if (parent instanceof ASTArrayAllocation) {
            return ((ASTArrayAllocation)parent).getTypeMirror(ctx);
        }
        if (parent instanceof ASTVariableDeclarator) {
            ASTVariableDeclaratorId id = ((ASTVariableDeclarator)parent).getVarId();
            return id.isTypeInferred() ? this.ts.ERROR : id.getTypeMirror(ctx);
        }
        if (parent instanceof ASTArrayInitializer) {
            JTypeMirror tm = ((ASTArrayInitializer)parent).getTypeMirror(ctx);
            return tm instanceof JArrayType ? ((JArrayType)tm).getComponentType() : this.ts.ERROR;
        }
        return this.ts.ERROR;
    }

    @Override
    public JTypeMirror visit(ASTVariableAccess node, TypingContext ctx) {
        ASTVariableDeclaratorId id;
        ASTSwitchLike switchParent;
        JTypeMirror testedType;
        JTypeDeclSymbol testedSym;
        if (node.getParent() instanceof ASTSwitchLabel && (testedSym = (testedType = (switchParent = (ASTSwitchLike)node.ancestors(ASTSwitchLike.class).firstOrThrow()).getTestedExpression().getTypeMirror(ctx)).getSymbol()) instanceof JClassSymbol && ((JClassSymbol)testedSym).isEnum()) {
            JFieldSymbol enumConstant = ((JClassSymbol)testedSym).getDeclaredField(node.getName());
            if (enumConstant != null) {
                InternalApiBridge.setTypedSym(node, (JVariableSig)this.ts.sigOf(testedType, enumConstant));
            }
            return testedType;
        }
        @Nullable JVariableSig result = node.getSymbolTable().variables().resolveFirst(node.getName());
        if (result == null) {
            return this.polyResolution.getContextTypeForStandaloneFallback(node);
        }
        InternalApiBridge.setTypedSym(node, result);
        JTypeMirror resultMirror = null;
        if (result.getSymbol() instanceof JLocalVariableSymbol && (id = (ASTVariableDeclaratorId)result.getSymbol().tryGetNode()) != null && id.isLambdaParameter()) {
            resultMirror = id.getTypeMirror();
        }
        if (resultMirror == null) {
            resultMirror = result.getTypeMirror();
        }
        return node.getAccessType() == ASTAssignableExpr.AccessType.READ ? TypeConversion.capture(resultMirror) : resultMirror;
    }

    @Override
    public @NonNull JTypeMirror visit(ASTLambdaParameter node, TypingContext ctx) {
        if (node.getTypeNode() != null) {
            return node.getTypeNode().getTypeMirror(ctx);
        }
        ASTLambdaExpression lambda = (ASTLambdaExpression)node.ancestors(ASTLambdaExpression.class).firstOrThrow();
        lambda.getTypeMirror(ctx);
        JMethodSig m = lambda.getFunctionalMethod();
        if (!this.isUnresolved(m)) {
            if (m.getArity() != node.getOwner().getArity()) {
                this.err.warning((Node)node.getOwner(), "Lambda shape does not conform to the functional method {0}", new Object[]{m});
                return this.ts.ERROR;
            }
            return m.getFormalParameters().get(node.getIndexInParent());
        }
        return this.ts.UNKNOWN;
    }

    @Override
    public JTypeMirror visit(ASTFieldAccess node, TypingContext ctx) {
        JTypeMirror qualifierT = TypeConversion.capture(node.getQualifier().getTypeMirror(ctx));
        if (this.isUnresolved(qualifierT)) {
            return this.polyResolution.getContextTypeForStandaloneFallback(node);
        }
        @Nullable ASTAnyTypeDeclaration enclosingType = node.getEnclosingType();
        @Nullable JClassSymbol enclosingSymbol = enclosingType == null ? null : enclosingType.getSymbol();
        NameResolver<JVariableSig.FieldSig> fieldResolver = TypeOps.getMemberFieldResolver(qualifierT, node.getRoot().getPackageName(), enclosingSymbol, node.getName());
        JVariableSig.FieldSig sig = fieldResolver.resolveFirst(node.getName());
        InternalApiBridge.setTypedSym(node, sig);
        if (sig == null) {
            return this.polyResolution.getContextTypeForStandaloneFallback(node);
        }
        return node.getAccessType() == ASTAssignableExpr.AccessType.READ ? TypeConversion.capture(sig.getTypeMirror()) : sig.getTypeMirror();
    }

    @Override
    public JTypeMirror visit(ASTArrayAccess node, TypingContext ctx) {
        JTypeMirror arrType = node.getQualifier().getTypeMirror(ctx);
        JTypeMirror compType = arrType instanceof JArrayType ? ((JArrayType)arrType).getComponentType() : (this.isUnresolved(arrType) ? this.polyResolution.getContextTypeForStandaloneFallback(node) : this.ts.ERROR);
        return TypeConversion.capture(compType);
    }

    @Override
    public JTypeMirror visit(ASTSuperExpression node, TypingContext ctx) {
        if (node.getQualifier() != null) {
            return node.getQualifier().getTypeMirror(ctx);
        }
        return ((JClassType)node.getEnclosingType().getTypeMirror(ctx)).getSuperClass();
    }

    @Override
    public JTypeMirror visit(ASTThisExpression node, TypingContext ctx) {
        return node.getQualifier() != null ? node.getQualifier().getTypeMirror(ctx) : node.getEnclosingType().getTypeMirror(ctx);
    }

    @Override
    public JTypeMirror visit(ASTAmbiguousName node, TypingContext ctx) {
        return this.ts.UNKNOWN;
    }
}

