/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JIntersectionType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class Lub {
    private Lub() {
    }

    static JTypeMirror lub(TypeSystem ts, Collection<? extends JTypeMirror> us) {
        return new LubJudge(ts).lub(us);
    }

    private static JTypeMirror upperBound(JTypeMirror type) {
        if (type instanceof JWildcardType) {
            return ((JWildcardType)type).asUpperBound();
        }
        return type;
    }

    private static JTypeMirror lowerBound(JTypeMirror type) {
        if (type instanceof JWildcardType) {
            return ((JWildcardType)type).asLowerBound();
        }
        return type;
    }

    private static boolean isUpperBound(JTypeMirror type) {
        return type instanceof JWildcardType && ((JWildcardType)type).isUpperBound();
    }

    private static boolean isLowerBound(JTypeMirror type) {
        return type instanceof JWildcardType && ((JWildcardType)type).isLowerBound();
    }

    static @Nullable List<JClassType> relevant(JClassType g, Set<JTypeMirror> stunion) {
        if (!g.isRaw()) {
            return null;
        }
        ArrayList<JClassType> list = new ArrayList<JClassType>();
        for (JTypeMirror it : stunion) {
            if (!(it instanceof JClassType) || !it.getErasure().equals(g) || it.isRaw()) continue;
            list.add((JClassType)it);
        }
        return list;
    }

    private static Set<JTypeMirror> erasedSuperTypes(Set<JTypeMirror> stui) {
        LinkedHashSet<JTypeMirror> erased = new LinkedHashSet<JTypeMirror>();
        for (JTypeMirror it : stui) {
            JTypeMirror t = it instanceof JTypeVar ? it : it.getErasure();
            erased.add(t);
        }
        return erased;
    }

    static JTypeMirror glb(TypeSystem ts, Collection<? extends JTypeMirror> types) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Cannot compute GLB of empty set");
        }
        if (types.size() == 1) {
            return types.iterator().next();
        }
        List<JTypeMirror> flat = Lub.flattenRemoveTrivialBound(types);
        if (flat.size() == 1) {
            return flat.get(0);
        }
        if (flat.isEmpty()) {
            return ts.OBJECT;
        }
        Set<JTypeMirror> mostSpecific = TypeOps.mostSpecific(flat);
        assert (!mostSpecific.isEmpty()) : "Empty most specific for bounds " + flat;
        if (mostSpecific.size() == 1) {
            return mostSpecific.iterator().next();
        }
        ArrayList<JTypeMirror> bounds = new ArrayList<JTypeMirror>(mostSpecific);
        JTypeMirror primaryBound = null;
        for (int i = 0; i < bounds.size(); ++i) {
            JTypeMirror ci = (JTypeMirror)bounds.get(i);
            if (!Lub.isExclusiveIntersectionBound(ci)) continue;
            if (primaryBound == null) {
                primaryBound = ci;
                Collections.swap(bounds, 0, i);
                continue;
            }
            throw new IllegalArgumentException("Bad intersection, unrelated class types " + ci + " and " + primaryBound + " in " + types);
        }
        if (primaryBound == null) {
            if (bounds.size() == 1) {
                return (JTypeMirror)bounds.get(0);
            }
            primaryBound = ts.OBJECT;
        }
        return new JIntersectionType(ts, primaryBound, bounds);
    }

    private static void checkGlbComponent(Collection<? extends JTypeMirror> types, JTypeMirror ci) {
        if (ci.isPrimitive() || ci instanceof JWildcardType || ci instanceof JIntersectionType) {
            throw new IllegalArgumentException("Bad intersection type component: " + ci + " in " + types);
        }
    }

    private static @NonNull List<JTypeMirror> flattenRemoveTrivialBound(Collection<? extends JTypeMirror> types) {
        ArrayList<JTypeMirror> bounds = new ArrayList<JTypeMirror>(types.size());
        for (JTypeMirror jTypeMirror : types) {
            if (jTypeMirror instanceof JIntersectionType) {
                bounds.addAll(((JIntersectionType)jTypeMirror).getComponents());
                continue;
            }
            Lub.checkGlbComponent(types, jTypeMirror);
            if (jTypeMirror.isTop()) continue;
            bounds.add(jTypeMirror);
        }
        return bounds;
    }

    static boolean isExclusiveIntersectionBound(JTypeMirror ci) {
        return !ci.isInterface() && !(ci instanceof InferenceVar) && (ci.getSymbol() == null || !ci.getSymbol().isUnresolved());
    }

    private static final class TypePair {
        public final JTypeMirror left;
        public final JTypeMirror right;

        TypePair(JTypeMirror left, JTypeMirror right) {
            this.left = left;
            this.right = right;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypePair pair = (TypePair)o;
            return Objects.equals(this.left, pair.left) && Objects.equals(this.right, pair.right);
        }

        public int hashCode() {
            return Objects.hash(this.left, this.right);
        }

        public String toString() {
            return "Pair(" + this.left + " - " + this.right + ")";
        }
    }

    private static class LubJudge {
        private final Set<TypePair> lubCache = new HashSet<TypePair>();
        private final TypeSystem ts;

        LubJudge(TypeSystem ts) {
            this.ts = ts;
        }

        JTypeMirror lub(JTypeMirror ... in) {
            return this.lub(Arrays.asList(in));
        }

        JTypeMirror glb(JTypeMirror ... in) {
            return this.ts.glb(Arrays.asList(in));
        }

        JTypeMirror lub(Collection<? extends JTypeMirror> in) {
            if (in.isEmpty()) {
                throw new IllegalArgumentException("Empty set for lub?");
            }
            LinkedHashSet<? extends JTypeMirror> us = new LinkedHashSet<JTypeMirror>(in);
            us.remove(this.ts.NULL_TYPE);
            Iterator uIterator = us.iterator();
            if (us.size() == 1) {
                return (JTypeMirror)uIterator.next();
            }
            if (us.isEmpty()) {
                return this.ts.NULL_TYPE;
            }
            LinkedHashSet<JTypeMirror> stunion = new LinkedHashSet<JTypeMirror>(((JTypeMirror)uIterator.next()).box().getSuperTypeSet());
            Set ec = Lub.erasedSuperTypes(stunion);
            while (uIterator.hasNext()) {
                Set<JTypeMirror> stui = ((JTypeMirror)uIterator.next()).box().getSuperTypeSet();
                Set estui = Lub.erasedSuperTypes(stui);
                ec.retainAll(estui);
                stunion.addAll(stui);
            }
            Set<JTypeMirror> mec = TypeOps.mostSpecific(ec);
            List best = CollectionUtil.map(mec, g -> {
                if (g instanceof JClassType) {
                    List<JClassType> relevant = Lub.relevant((JClassType)g, stunion);
                    return relevant != null ? this.lcp(relevant) : g;
                }
                return g;
            });
            return best.isEmpty() ? this.ts.OBJECT : this.ts.glb(best);
        }

        private JClassType lcp(List<JClassType> relevant) {
            if (relevant.isEmpty()) {
                throw new IllegalArgumentException("Empty set");
            }
            if (relevant.size() == 1) {
                return relevant.get(0);
            }
            JClassType acc = this.lcp(relevant.get(0), relevant.get(1));
            for (int i = 2; i < relevant.size(); ++i) {
                acc = this.lcp(acc, relevant.get(i));
            }
            return acc;
        }

        private JClassType lcp(JClassType t, JClassType s) {
            int n = t.getFormalTypeParams().size();
            ArrayList<JTypeMirror> leastArgs = new ArrayList<JTypeMirror>(n);
            List<JTypeMirror> targs = t.getTypeArgs();
            List<JTypeMirror> sargs = s.getTypeArgs();
            for (int i = 0; i < n; ++i) {
                leastArgs.add(this.lcta(targs.get(i), sargs.get(i)));
            }
            return t.withTypeArguments(leastArgs);
        }

        private JTypeMirror lcta(JTypeMirror t, JTypeMirror s) {
            TypePair pair = new TypePair(t, s);
            if (this.lubCache.add(pair)) {
                JTypeMirror res = this.computeLcta(t, s);
                this.lubCache.remove(pair);
                return res;
            }
            return this.ts.UNBOUNDED_WILD;
        }

        private @NonNull JTypeMirror computeLcta(JTypeMirror t, JTypeMirror s) {
            if (t.equals(s)) {
                return t;
            }
            if (Lub.isUpperBound(t) && Lub.isLowerBound(s)) {
                return this.ts.UNBOUNDED_WILD;
            }
            if (Lub.isUpperBound(s)) {
                return this.ts.wildcard(true, this.lub(Lub.upperBound(t), Lub.upperBound(s)));
            }
            if (Lub.isLowerBound(s)) {
                return this.ts.wildcard(false, this.glb(Lub.lowerBound(t), Lub.lowerBound(s)));
            }
            return this.ts.wildcard(true, this.lub(t, s));
        }
    }
}

