/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.ArrayList;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class UseStringBufferForStringAppendsRule
extends AbstractJavaRulechainRule {
    public UseStringBufferForStringAppendsRule() {
        super(ASTVariableDeclaratorId.class, new Class[0]);
    }

    @Override
    public Object visit(ASTVariableDeclaratorId node, Object data) {
        if (!TypeTestUtil.isA(String.class, (TypeNode)node) || node.isForeachVariable()) {
            return data;
        }
        int usageCounter = 0;
        ArrayList<ASTAssignableExpr.ASTNamedReferenceExpr> possibleViolations = new ArrayList<ASTAssignableExpr.ASTNamedReferenceExpr>();
        for (ASTAssignableExpr.ASTNamedReferenceExpr usage : node.getLocalUsages()) {
            if ((node.isField() || node.isFormalParameter()) && this.isNotWithinLoop((Node)usage)) continue;
            boolean isSimpleAssignment = false;
            if (usage.getParent() instanceof ASTAssignmentExpression) {
                ASTAssignmentExpression assignment = (ASTAssignmentExpression)usage.getParent();
                if (assignment.isCompound()) {
                    ++usageCounter;
                }
                int usageOnRightHandSide = JavaAstUtils.flattenOperands(assignment.getRightOperand()).filterIs(ASTAssignableExpr.ASTNamedReferenceExpr.class).filterMatching(ASTAssignableExpr.ASTNamedReferenceExpr::getReferencedSym, (Object)((JVariableSymbol)node.getSymbol())).count();
                usageCounter += usageOnRightHandSide;
                boolean bl = isSimpleAssignment = !assignment.isCompound() && usageOnRightHandSide == 0;
            }
            if (usage.getAccessType() != ASTAssignableExpr.AccessType.WRITE || isSimpleAssignment) continue;
            if (this.isWithinLoop((Node)usage)) {
                this.addViolation(data, (Node)usage);
                continue;
            }
            possibleViolations.add(usage);
        }
        if (usageCounter > 1) {
            possibleViolations.forEach(v -> this.addViolation(data, (Node)v));
        }
        return data;
    }

    private boolean isNotWithinLoop(Node name) {
        return name.ancestors(ASTLoopStatement.class).isEmpty();
    }

    private boolean isWithinLoop(Node name) {
        return !this.isNotWithinLoop(name);
    }
}

