/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTNumericLiteral;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class AvoidUsingOctalValuesRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> STRICT_METHODS_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"strict").desc("Detect violations between 00 and 07")).defaultValue((Object)false)).build();

    public AvoidUsingOctalValuesRule() {
        super(ASTNumericLiteral.class, new Class[0]);
        this.definePropertyDescriptor(STRICT_METHODS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTNumericLiteral node, Object data) {
        if (node.getBase() == 8 && (((Boolean)this.getProperty(STRICT_METHODS_DESCRIPTOR)).booleanValue() || !this.isBetweenZeroAnd7(node))) {
            this.addViolation(data, (Node)node);
        }
        return null;
    }

    private boolean isBetweenZeroAnd7(ASTNumericLiteral node) {
        long value = node.getConstValue().longValue();
        return 0L <= value && value <= 7L;
    }
}

