/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBreakStatement;
import net.sourceforge.pmd.lang.java.ast.ASTContinueStatement;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFinallyClause;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.StringUtils;

public class AvoidBranchingStatementAsLastInLoopRule
extends AbstractJavaRulechainRule {
    public static final String CHECK_FOR = "for";
    public static final String CHECK_DO = "do";
    public static final String CHECK_WHILE = "while";
    private static final Map<String, String> LOOP_TYPES_MAPPINGS;
    private static final List<String> DEFAULTS;
    public static final PropertyDescriptor<List<String>> CHECK_BREAK_LOOP_TYPES;
    public static final PropertyDescriptor<List<String>> CHECK_CONTINUE_LOOP_TYPES;
    public static final PropertyDescriptor<List<String>> CHECK_RETURN_LOOP_TYPES;

    public AvoidBranchingStatementAsLastInLoopRule() {
        super(ASTBreakStatement.class, ASTContinueStatement.class, ASTReturnStatement.class);
        this.definePropertyDescriptor(CHECK_BREAK_LOOP_TYPES);
        this.definePropertyDescriptor(CHECK_CONTINUE_LOOP_TYPES);
        this.definePropertyDescriptor(CHECK_RETURN_LOOP_TYPES);
    }

    @Override
    public Object visit(ASTBreakStatement node, Object data) {
        if (node.ancestors().get(1) instanceof ASTSwitchStatement) {
            return data;
        }
        return this.check(CHECK_BREAK_LOOP_TYPES, (Node)node, data);
    }

    protected Object check(PropertyDescriptor<List<String>> property, Node node, Object data) {
        Node parent = node.getParent();
        if (parent instanceof ASTBlock && (parent = parent.getParent()) instanceof ASTFinallyClause) {
            parent = parent.getNthParent(3);
        }
        if (parent instanceof ASTForStatement || parent instanceof ASTForeachStatement) {
            if (this.hasPropertyValue(property, CHECK_FOR)) {
                super.addViolation(data, node);
            }
        } else if (parent instanceof ASTWhileStatement) {
            if (this.hasPropertyValue(property, CHECK_WHILE)) {
                super.addViolation(data, node);
            }
        } else if (parent instanceof ASTDoStatement && this.hasPropertyValue(property, CHECK_DO)) {
            super.addViolation(data, node);
        }
        return data;
    }

    protected boolean hasPropertyValue(PropertyDescriptor<List<String>> property, String value) {
        return ((List)this.getProperty(property)).contains(value);
    }

    @Override
    public Object visit(ASTContinueStatement node, Object data) {
        return this.check(CHECK_CONTINUE_LOOP_TYPES, (Node)node, data);
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        return this.check(CHECK_RETURN_LOOP_TYPES, (Node)node, data);
    }

    public String dysfunctionReason() {
        return this.checksNothing() ? "All loop types are ignored" : null;
    }

    private static PropertyDescriptor<List<String>> propertyFor(String stmtName) {
        return ((PropertyBuilder.GenericCollectionPropertyBuilder)((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.enumListProperty((String)("check" + StringUtils.capitalize((String)stmtName) + "LoopTypes"), LOOP_TYPES_MAPPINGS).desc("List of loop types in which " + stmtName + " statements will be checked")).defaultValue(DEFAULTS)).build();
    }

    public boolean checksNothing() {
        return ((List)this.getProperty(CHECK_BREAK_LOOP_TYPES)).isEmpty() && ((List)this.getProperty(CHECK_CONTINUE_LOOP_TYPES)).isEmpty() && ((List)this.getProperty(CHECK_RETURN_LOOP_TYPES)).isEmpty();
    }

    static {
        DEFAULTS = Arrays.asList(CHECK_FOR, CHECK_DO, CHECK_WHILE);
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put(CHECK_FOR, CHECK_FOR);
        mappings.put(CHECK_DO, CHECK_DO);
        mappings.put(CHECK_WHILE, CHECK_WHILE);
        LOOP_TYPES_MAPPINGS = Collections.unmodifiableMap(mappings);
        CHECK_BREAK_LOOP_TYPES = AvoidBranchingStatementAsLastInLoopRule.propertyFor("break");
        CHECK_CONTINUE_LOOP_TYPES = AvoidBranchingStatementAsLastInLoopRule.propertyFor("continue");
        CHECK_RETURN_LOOP_TYPES = AvoidBranchingStatementAsLastInLoopRule.propertyFor("return");
    }
}

