/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.rule.codestyle.AbstractNamingConventionRule;
import net.sourceforge.pmd.lang.java.rule.internal.TestFrameworksUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class MethodNamingConventionsRule
extends AbstractNamingConventionRule<ASTMethodDeclaration> {
    private final Map<String, String> descriptorToDisplayName = new HashMap<String, String>();
    private final PropertyDescriptor<Pattern> instanceRegex = this.defaultProp("", "instance").build();
    private final PropertyDescriptor<Pattern> staticRegex = this.defaultProp("static").build();
    private final PropertyDescriptor<Pattern> nativeRegex = this.defaultProp("native").build();
    private final PropertyDescriptor<Pattern> junit3Regex = this.defaultProp("JUnit 3 test").defaultValue("test[A-Z0-9][a-zA-Z0-9]*").build();
    private final PropertyDescriptor<Pattern> junit4Regex = this.defaultProp("JUnit 4 test").build();
    private final PropertyDescriptor<Pattern> junit5Regex = this.defaultProp("JUnit 5 test").build();

    public MethodNamingConventionsRule() {
        super(ASTMethodDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(this.instanceRegex);
        this.definePropertyDescriptor(this.staticRegex);
        this.definePropertyDescriptor(this.nativeRegex);
        this.definePropertyDescriptor(this.junit3Regex);
        this.definePropertyDescriptor(this.junit4Regex);
        this.definePropertyDescriptor(this.junit5Regex);
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        if (node.isOverridden()) {
            return data;
        }
        if (node.hasModifiers(JModifier.NATIVE, new JModifier[0])) {
            this.checkMatches(node, this.nativeRegex, data);
        } else if (node.isStatic()) {
            this.checkMatches(node, this.staticRegex, data);
        } else if (TestFrameworksUtil.isJUnit5Method(node)) {
            this.checkMatches(node, this.junit5Regex, data);
        } else if (TestFrameworksUtil.isJUnit4Method(node)) {
            this.checkMatches(node, this.junit4Regex, data);
        } else if (TestFrameworksUtil.isJUnit3Method(node)) {
            this.checkMatches(node, this.junit3Regex, data);
        } else {
            this.checkMatches(node, this.instanceRegex, data);
        }
        return data;
    }

    @Override
    String defaultConvention() {
        return "[a-z][a-zA-Z0-9]*";
    }

    @Override
    String nameExtractor(ASTMethodDeclaration node) {
        return node.getName();
    }

    @Override
    PropertyBuilder.RegexPropertyBuilder defaultProp(String name, String displayName) {
        String display = (displayName + " method").trim();
        PropertyBuilder.RegexPropertyBuilder prop = super.defaultProp(name.isEmpty() ? "method" : name, display);
        this.descriptorToDisplayName.put(prop.getName(), display);
        return prop;
    }

    @Override
    String kindDisplayName(ASTMethodDeclaration node, PropertyDescriptor<Pattern> descriptor) {
        return this.descriptorToDisplayName.get(descriptor.name());
    }
}

