/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JAccessibleElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JMethodSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.rule.AbstractRule;

public class AccessorMethodGenerationRule
extends AbstractJavaRulechainRule {
    private final Set<JavaNode> reportedNodes = new HashSet<JavaNode>();

    public AccessorMethodGenerationRule() {
        super(ASTFieldAccess.class, ASTVariableAccess.class, ASTMethodCall.class);
    }

    public void end(RuleContext ctx) {
        super.end(ctx);
        this.reportedNodes.clear();
    }

    @Override
    public Object visit(ASTFieldAccess node, Object data) {
        JFieldSymbol sym = node.getReferencedSym();
        if (sym != null && sym.getConstValue() == null) {
            this.checkMemberAccess((RuleContext)data, node, sym);
        }
        return null;
    }

    @Override
    public Object visit(ASTVariableAccess node, Object data) {
        JVariableSymbol sym = node.getReferencedSym();
        if (sym instanceof JFieldSymbol) {
            JFieldSymbol fieldSym = (JFieldSymbol)sym;
            if (((JFieldSymbol)sym).getConstValue() == null) {
                this.checkMemberAccess((RuleContext)data, node, fieldSym);
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTMethodCall node, Object data) {
        JMethodSymbol symbol = (JMethodSymbol)node.getMethodType().getSymbol();
        this.checkMemberAccess((RuleContext)data, node, symbol);
        return null;
    }

    private void checkMemberAccess(RuleContext data, ASTExpression node, JAccessibleElementSymbol symbol) {
        AccessorMethodGenerationRule.checkMemberAccess(this, data, node, symbol, this.reportedNodes);
    }

    static void checkMemberAccess(AbstractRule rule, RuleContext data, JavaNode refExpr, JAccessibleElementSymbol sym, Set<JavaNode> reportedNodes) {
        if (Modifier.isPrivate(sym.getModifiers()) && !Objects.equals(sym.getEnclosingClass(), refExpr.getEnclosingType().getSymbol())) {
            JavaNode node = sym.tryGetNode();
            assert (node != null) : "Node should be in the same compilation unit";
            if (reportedNodes.add(node)) {
                rule.addViolation((Object)data, (Node)node, (Object[])new String[]{AccessorMethodGenerationRule.stripPackageName(refExpr.getEnclosingType().getSymbol())});
            }
        }
    }

    private static String stripPackageName(JClassSymbol symbol) {
        String p = symbol.getPackageName();
        String canoName = symbol.getCanonicalName();
        if (canoName == null) {
            return symbol.getSimpleName();
        }
        if (p.isEmpty()) {
            return canoName;
        }
        return canoName.substring(p.length() + 1);
    }
}

