/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Iterator;
import net.sourceforge.pmd.lang.ast.AstVisitor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.java.ast.ASTAmbiguousName;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTList;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableAccess;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaExpr;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.TokenUtils;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.JSymbolTable;
import net.sourceforge.pmd.lang.java.symbols.table.internal.ReferenceCtx;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JVariableSig;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AstDisambiguationPass {
    private AstDisambiguationPass() {
    }

    public static void disambigWithCtx(NodeStream<? extends JavaNode> nodes, ReferenceCtx ctx) {
        assert (ctx != null) : "Null context";
        nodes.forEach(it -> it.acceptVisitor(DisambigVisitor.INSTANCE, ctx));
    }

    private static void checkParentIsMember(ReferenceCtx ctx, ASTClassOrInterfaceType resolvedType, ASTClassOrInterfaceType parent) {
        JTypeDeclSymbol sym = resolvedType.getReferencedSym();
        JClassSymbol parentClass = ctx.findTypeMember(sym, parent.getSimpleName(), parent);
        if (parentClass == null) {
            ctx.reportUnresolvedMember(parent, ReferenceCtx.Fallback.TYPE, parent.getSimpleName(), sym);
            int numTypeArgs = ASTList.sizeOrZero(parent.getTypeArguments());
            parentClass = ctx.makeUnresolvedReference(sym, parent.getSimpleName(), numTypeArgs);
        }
        parent.setSymbol(parentClass);
    }

    private static @Nullable JClassType enclosingType(JTypeMirror typeResult) {
        return typeResult instanceof JClassType ? ((JClassType)typeResult).getEnclosingType() : null;
    }

    private static final class DisambigVisitor
    extends JavaVisitorBase<ReferenceCtx, Void> {
        public static final DisambigVisitor INSTANCE = new DisambigVisitor();

        private DisambigVisitor() {
        }

        protected Void visitChildren(Node node, ReferenceCtx data) {
            for (int i = 0; i < node.getNumChildren(); ++i) {
                node.getChild(i).acceptVisitor((AstVisitor)this, (Object)data);
            }
            return null;
        }

        @Override
        public Void visitTypeDecl(ASTAnyTypeDeclaration node, ReferenceCtx data) {
            return this.visitChildren((Node)node, data.scopeDownToNested(node.getSymbol()));
        }

        @Override
        public Void visit(ASTAmbiguousName name, ReferenceCtx processor) {
            boolean isPackageOrTypeOnly;
            if (name.wasProcessed()) {
                return null;
            }
            JSymbolTable symbolTable = name.getSymbolTable();
            assert (symbolTable != null) : "Symbol tables haven't been set yet??";
            if (name.getParent() instanceof ASTClassOrInterfaceType) {
                isPackageOrTypeOnly = true;
            } else if (name.getParent() instanceof ASTExpression) {
                isPackageOrTypeOnly = false;
            } else {
                throw new AssertionError((Object)("Unrecognised context for ambiguous name: " + name.getParent()));
            }
            TypeNode resolved = DisambigVisitor.startResolve(name, processor, isPackageOrTypeOnly);
            assert (!isPackageOrTypeOnly || resolved instanceof ASTTypeExpression || resolved instanceof ASTAmbiguousName) : "Unexpected result " + resolved + " for PackageOrTypeName resolution";
            if (isPackageOrTypeOnly && resolved instanceof ASTTypeExpression) {
                ASTClassOrInterfaceType resolvedType = (ASTClassOrInterfaceType)((ASTTypeExpression)resolved).getTypeNode();
                resolved = resolvedType;
                ASTClassOrInterfaceType parent = (ASTClassOrInterfaceType)name.getParent();
                AstDisambiguationPass.checkParentIsMember(processor, resolvedType, parent);
            }
            if (resolved != name) {
                ((AbstractJavaNode)name.getParent()).setChild((AbstractJavaNode)((Object)resolved), name.getIndexInParent());
            }
            return null;
        }

        @Override
        public Void visit(ASTClassOrInterfaceType type, ReferenceCtx ctx) {
            if (type.getReferencedSym() != null) {
                return null;
            }
            if (type.getFirstChild() instanceof ASTAmbiguousName) {
                ((JavaNode)type.getFirstChild()).acceptVisitor(this, ctx);
            }
            this.visitChildren((Node)type, ctx);
            if (type.getReferencedSym() != null) {
                this.postProcess(type, ctx);
                return null;
            }
            ASTClassOrInterfaceType lhsType = type.getQualifier();
            if (lhsType != null) {
                JTypeDeclSymbol lhsSym = lhsType.getReferencedSym();
                assert (lhsSym != null) : "Unresolved LHS for " + type;
                AstDisambiguationPass.checkParentIsMember(ctx, lhsType, type);
            } else {
                if (type.getParent() instanceof ASTConstructorCall && ((ASTConstructorCall)type.getParent()).isQualifiedInstanceCreation()) {
                    return null;
                }
                if (type.getReferencedSym() == null) {
                    DisambigVisitor.setClassSymbolIfNoQualifier(type, ctx);
                }
            }
            assert (type.getReferencedSym() != null) : "Null symbol for " + type;
            this.postProcess(type, ctx);
            return null;
        }

        private static void setClassSymbolIfNoQualifier(ASTClassOrInterfaceType type, ReferenceCtx ctx) {
            JTypeDeclSymbol sym;
            JTypeMirror resolved = ctx.resolveSingleTypeName(type.getSymbolTable(), type.getSimpleName(), type);
            if (resolved == null) {
                ctx.reportCannotResolveSymbol(type, type.getSimpleName());
                sym = DisambigVisitor.setArity(type, ctx, type.getSimpleName());
            } else {
                sym = resolved.getSymbol();
                if (sym.isUnresolved()) {
                    sym = DisambigVisitor.setArity(type, ctx, ((JClassSymbol)sym).getCanonicalName());
                }
            }
            type.setSymbol(sym);
            type.setImplicitEnclosing(AstDisambiguationPass.enclosingType(resolved));
        }

        private void postProcess(ASTClassOrInterfaceType type, ReferenceCtx ctx) {
            int expectedArity;
            JTypeDeclSymbol sym = type.getReferencedSym();
            if (type.getParent() instanceof ASTAnnotation) {
                if (!(sym instanceof JClassSymbol) || !sym.isUnresolved() && !((JClassSymbol)sym).isAnnotation()) {
                    ctx.getLogger().warning((Node)type, "Expected an annotation type", new Object[0]);
                }
                return;
            }
            int actualArity = ASTList.sizeOrZero(type.getTypeArguments());
            int n = expectedArity = sym instanceof JClassSymbol ? ((JClassSymbol)sym).getTypeParameterCount() : 0;
            if (actualArity != 0 && actualArity != expectedArity) {
                ctx.getLogger().warning((Node)type, "Malformed generic type: expected {0} type arguments, got {1}", new Object[]{expectedArity, actualArity});
            }
        }

        private static @NonNull JTypeDeclSymbol setArity(ASTClassOrInterfaceType type, ReferenceCtx ctx, String canonicalName) {
            int arity = ASTList.sizeOrZero(type.getTypeArguments());
            return ctx.makeUnresolvedReference(canonicalName, arity);
        }

        private static ASTExpression startResolve(ASTAmbiguousName name, ReferenceCtx ctx, boolean isPackageOrTypeOnly) {
            JVariableSig varResult;
            Iterator<JavaccToken> tokens = name.tokens().iterator();
            JavaccToken firstIdent = (JavaccToken)tokens.next();
            TokenUtils.expectKind(firstIdent, 82);
            JSymbolTable symTable = name.getSymbolTable();
            if (!isPackageOrTypeOnly && (varResult = symTable.variables().resolveFirst(firstIdent.getImage())) != null) {
                return DisambigVisitor.resolveExpr(null, varResult, firstIdent, tokens, ctx);
            }
            JTypeMirror typeResult = ctx.resolveSingleTypeName(symTable, firstIdent.getImage(), name);
            if (typeResult != null) {
                JClassType enclosing = AstDisambiguationPass.enclosingType(typeResult);
                return DisambigVisitor.resolveType(null, enclosing, typeResult.getSymbol(), false, firstIdent, tokens, name, isPackageOrTypeOnly, ctx);
            }
            return DisambigVisitor.resolvePackage(firstIdent, new StringBuilder(firstIdent.getImage()), tokens, name, isPackageOrTypeOnly, ctx);
        }

        private static ASTExpression resolveExpr(@Nullable ASTExpression qualifier, @Nullable JVariableSig varSym, JavaccToken identifier, Iterator<JavaccToken> remaining, ReferenceCtx ctx) {
            AbstractJavaExpr var;
            TokenUtils.expectKind(identifier, 82);
            if (qualifier == null) {
                ASTVariableAccess varAccess = new ASTVariableAccess(identifier);
                varAccess.setTypedSym(varSym);
                var = varAccess;
            } else {
                ASTFieldAccess fieldAccess = new ASTFieldAccess(qualifier, identifier);
                fieldAccess.setTypedSym((JVariableSig.FieldSig)varSym);
                var = fieldAccess;
            }
            if (!remaining.hasNext()) {
                return var;
            }
            JavaccToken nextIdent = DisambigVisitor.skipToNextIdent(remaining);
            return DisambigVisitor.resolveExpr(var, null, nextIdent, remaining, ctx);
        }

        private static ASTExpression resolveType(@Nullable ASTClassOrInterfaceType qualifier, @Nullable JClassType implicitEnclosing, JTypeDeclSymbol sym, boolean isFqcn, JavaccToken identifier, Iterator<JavaccToken> remaining, ASTAmbiguousName ambig, boolean isPackageOrTypeOnly, ReferenceCtx ctx) {
            JVariableSig.FieldSig field;
            TokenUtils.expectKind(identifier, 82);
            ASTClassOrInterfaceType type = new ASTClassOrInterfaceType(qualifier, isFqcn, ambig.getFirstToken(), identifier);
            type.setSymbol(sym);
            type.setImplicitEnclosing(implicitEnclosing);
            if (!remaining.hasNext()) {
                return new ASTTypeExpression(type);
            }
            JavaccToken nextIdent = DisambigVisitor.skipToNextIdent(remaining);
            String nextSimpleName = nextIdent.getImage();
            if (!isPackageOrTypeOnly && (field = ctx.findStaticField(sym, nextSimpleName)) != null) {
                ASTTypeExpression typeExpr = new ASTTypeExpression(type);
                return DisambigVisitor.resolveExpr(typeExpr, field, nextIdent, remaining, ctx);
            }
            JClassSymbol inner = ctx.findTypeMember(sym, nextSimpleName, ambig);
            if (inner == null && isPackageOrTypeOnly) {
                ctx.reportUnresolvedMember(ambig, ReferenceCtx.Fallback.TYPE, nextSimpleName, sym);
                inner = ctx.makeUnresolvedReference(sym, nextSimpleName, 0);
            }
            if (inner != null) {
                return DisambigVisitor.resolveType(type, null, inner, false, nextIdent, remaining, ambig, isPackageOrTypeOnly, ctx);
            }
            ctx.reportUnresolvedMember(ambig, ReferenceCtx.Fallback.FIELD_ACCESS, nextSimpleName, sym);
            ASTTypeExpression typeExpr = new ASTTypeExpression(type);
            return DisambigVisitor.resolveExpr(typeExpr, null, nextIdent, remaining, ctx);
        }

        private static ASTExpression resolvePackage(JavaccToken identifier, StringBuilder packageImage, Iterator<JavaccToken> remaining, ASTAmbiguousName ambig, boolean isPackageOrTypeOnly, ReferenceCtx ctx) {
            TokenUtils.expectKind(identifier, 82);
            if (!remaining.hasNext()) {
                if (isPackageOrTypeOnly) {
                    DisambigVisitor.forceResolveAsFullPackageNameOfParent(packageImage, ambig, ctx);
                    return ambig;
                }
                ctx.getLogger().warning((Node)ambig, "Cannot resolve ambiguous name {0}, treating it as {1}", new Object[]{packageImage, ReferenceCtx.Fallback.AMBIGUOUS});
                ambig.setProcessed();
                return ambig;
            }
            JavaccToken nextIdent = DisambigVisitor.skipToNextIdent(remaining);
            packageImage.append('.').append(nextIdent.getImage());
            String canonical = packageImage.toString();
            JClassSymbol nextClass = ctx.resolveClassFromBinaryName(canonical);
            if (nextClass != null) {
                return DisambigVisitor.resolveType(null, null, nextClass, true, nextIdent, remaining, ambig, isPackageOrTypeOnly, ctx);
            }
            return DisambigVisitor.resolvePackage(nextIdent, packageImage, remaining, ambig, isPackageOrTypeOnly, ctx);
        }

        private static void forceResolveAsFullPackageNameOfParent(StringBuilder packageImage, ASTAmbiguousName ambig, ReferenceCtx ctx) {
            ASTClassOrInterfaceType parent = (ASTClassOrInterfaceType)ambig.getParent();
            packageImage.append('.').append(parent.getSimpleName());
            String fullName = packageImage.toString();
            JClassSymbol parentClass = ctx.resolveClassFromBinaryName(fullName);
            if (parentClass == null) {
                ctx.getLogger().warning((Node)parent, "Cannot resolve ambiguous name {0}, treating it as {1}", new Object[]{fullName, ReferenceCtx.Fallback.TYPE});
                parentClass = ctx.makeUnresolvedReference(fullName, ASTList.sizeOrZero(parent.getTypeArguments()));
            }
            parent.setSymbol(parentClass);
            parent.setFullyQualified();
            ambig.deleteInParent();
        }

        private static JavaccToken skipToNextIdent(Iterator<JavaccToken> remaining) {
            JavaccToken dot = remaining.next();
            TokenUtils.expectKind(dot, 93);
            assert (remaining.hasNext()) : "Ambiguous name must end with an identifier";
            return remaining.next();
        }
    }
}

