/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArrayDimensions;
import net.sourceforge.pmd.lang.java.ast.ASTArrayType;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTCatchParameter;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTForInit;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.ASTPattern;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.AbstractTypedSymbolDeclarator;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.FinalizableNode;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.java.ast.SymbolDeclaratorNode;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.rule.xpath.DeprecatedAttribute;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTVariableDeclaratorId
extends AbstractTypedSymbolDeclarator<JVariableSymbol>
implements AccessNode,
SymbolDeclaratorNode,
FinalizableNode {
    private List<ASTAssignableExpr.ASTNamedReferenceExpr> usages = Collections.emptyList();

    ASTVariableDeclaratorId(int id) {
        super(id);
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    public List<ASTAssignableExpr.ASTNamedReferenceExpr> getLocalUsages() {
        return this.usages;
    }

    void addUsage(ASTAssignableExpr.ASTNamedReferenceExpr usage) {
        if (this.usages.isEmpty()) {
            this.usages = new ArrayList<ASTAssignableExpr.ASTNamedReferenceExpr>(4);
        }
        this.usages.add(usage);
    }

    public @Nullable ASTArrayDimensions getExtraDimensions() {
        return (ASTArrayDimensions)this.children(ASTArrayDimensions.class).first();
    }

    @Override
    public @NonNull ASTModifierList getModifiers() {
        return this.getModifierOwnerParent().getModifiers();
    }

    @Override
    public AccessNode.Visibility getVisibility() {
        return this.isPatternBinding() ? AccessNode.Visibility.V_LOCAL : this.getModifierOwnerParent().getVisibility();
    }

    private AccessNode getModifierOwnerParent() {
        JavaNode parent = (JavaNode)this.getParent();
        if (parent instanceof ASTVariableDeclarator) {
            return (AccessNode)parent.getParent();
        }
        return (AccessNode)parent;
    }

    @DeprecatedAttribute(replaceWith="@Name")
    @Deprecated
    public String getImage() {
        return this.getName();
    }

    public String getName() {
        return super.getImage();
    }

    public boolean hasArrayType() {
        return this.getExtraDimensions() != null || this.getTypeNode() instanceof ASTArrayType;
    }

    public boolean isExceptionBlockParameter() {
        return this.getParent() instanceof ASTCatchParameter;
    }

    public boolean isFormalParameter() {
        return this.getParent() instanceof ASTFormalParameter || this.isLambdaParameter();
    }

    public boolean isRecordComponent() {
        return this.getParent() instanceof ASTRecordComponent;
    }

    public boolean isLocalVariable() {
        return this.getNthParent(2) instanceof ASTLocalVariableDeclaration && !this.isResourceDeclaration() && !this.isForeachVariable();
    }

    public boolean isForeachVariable() {
        return this.getNthParent(3) instanceof ASTForeachStatement;
    }

    public boolean isForLoopVariable() {
        return this.getNthParent(3) instanceof ASTForInit;
    }

    public boolean isLambdaParameter() {
        return this.getParent() instanceof ASTLambdaParameter;
    }

    public boolean isField() {
        return this.getNthParent(2) instanceof ASTFieldDeclaration;
    }

    public boolean isEnumConstant() {
        return this.getParent() instanceof ASTEnumConstant;
    }

    @Deprecated
    @DeprecatedAttribute(replaceWith="@Name")
    public String getVariableName() {
        return this.getName();
    }

    public boolean isResourceDeclaration() {
        return this.getParent() instanceof ASTResource;
    }

    public boolean isTypeInferred() {
        return this.getTypeNode() == null;
    }

    public boolean isPatternBinding() {
        return this.getParent() instanceof ASTPattern;
    }

    public @Nullable ASTExpression getInitializer() {
        if (this.getParent() instanceof ASTVariableDeclarator) {
            return ((ASTVariableDeclarator)this.getParent()).getInitializer();
        }
        return null;
    }

    public @Nullable Node getTypeNameNode() {
        return this.getTypeNode();
    }

    public @Nullable ASTType getTypeNode() {
        AccessNode parent = this.getModifierOwnerParent();
        return (ASTType)parent.firstChild(ASTType.class);
    }

    @Override
    public Class<?> getType() {
        return super.getType();
    }
}

