/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTNullLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class RedundantFieldInitializerRule
extends AbstractJavaRule {
    public RedundantFieldInitializerRule() {
        this.addRuleChainVisit(ASTFieldDeclaration.class);
    }

    @Override
    public Object visit(ASTFieldDeclaration fieldDeclaration, Object data) {
        if (this.declaresNotFinalField(fieldDeclaration)) {
            List varDecls = fieldDeclaration.findDescendantsOfType(ASTVariableDeclarator.class);
            for (ASTVariableDeclarator varDecl : varDecls) {
                if (!this.hasRedundantInitializer(fieldDeclaration, varDecl)) continue;
                this.addViolation(data, (Node)varDecl);
            }
        }
        return data;
    }

    private boolean declaresNotFinalField(ASTFieldDeclaration fieldDeclaration) {
        return !fieldDeclaration.isFinal();
    }

    private boolean hasRedundantInitializer(ASTFieldDeclaration fieldDeclaration, ASTVariableDeclarator varDecl) {
        return this.declaresFieldOfPrimitiveType(fieldDeclaration) && this.hasRedundantInitializerOfPrimitive(varDecl) || this.hasRedundantInitializerOfReference(varDecl);
    }

    private boolean declaresFieldOfPrimitiveType(ASTFieldDeclaration fieldDeclaration) {
        return ((JavaNode)fieldDeclaration.getChild(0)).getChild(0) instanceof ASTPrimitiveType;
    }

    private boolean hasRedundantInitializerOfPrimitive(ASTVariableDeclarator varDecl) {
        ASTLiteral literal = this.getLiteralValue(varDecl);
        if (literal != null) {
            if (this.isNumericLiteral(literal)) {
                return this.getNumericLiteralValue(literal) == 0.0;
            }
            if (literal.isCharLiteral()) {
                return this.hasDefaultCharLiteralValue(literal);
            }
            return this.isDefaultBooleanLiteral(literal);
        }
        return false;
    }

    private boolean isNumericLiteral(ASTLiteral literal) {
        return literal.isIntLiteral() || literal.isLongLiteral() || literal.isFloatLiteral() || literal.isDoubleLiteral();
    }

    private double getNumericLiteralValue(ASTLiteral literal) {
        if (literal.isIntLiteral()) {
            return literal.getValueAsInt();
        }
        if (literal.isLongLiteral()) {
            return literal.getValueAsLong();
        }
        if (literal.isFloatLiteral()) {
            return literal.getValueAsFloat();
        }
        return literal.getValueAsDouble();
    }

    private boolean hasDefaultCharLiteralValue(ASTLiteral literal) {
        String img = literal.getImage();
        return img.contains("\u0000") || img.contains("\\0");
    }

    private boolean isDefaultBooleanLiteral(ASTLiteral literal) {
        ASTBooleanLiteral booleanLiteral = (ASTBooleanLiteral)literal.getFirstDescendantOfType(ASTBooleanLiteral.class);
        return booleanLiteral != null && !booleanLiteral.isTrue();
    }

    private boolean hasRedundantInitializerOfReference(ASTVariableDeclarator varDecl) {
        ASTLiteral literal = this.getLiteralValue(varDecl);
        return literal != null && this.isNullLiteral(literal);
    }

    private ASTLiteral getLiteralValue(ASTVariableDeclarator varDecl) {
        ASTPrimaryPrefix prefix = (ASTPrimaryPrefix)varDecl.getFirstDescendantOfType(ASTPrimaryPrefix.class);
        return prefix != null && prefix.getNumChildren() == 1 ? (ASTLiteral)prefix.getFirstChildOfType(ASTLiteral.class) : null;
    }

    private boolean isNullLiteral(ASTLiteral literal) {
        return literal.getFirstDescendantOfType(ASTNullLiteral.class) != null;
    }
}

