/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPrimitiveType;
import net.sourceforge.pmd.lang.java.ast.ASTResultType;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class SimplifyBooleanReturnsRule
extends AbstractJavaRule {
    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        Node t;
        ASTResultType r = node.getResultType();
        if (!r.isVoid() && (t = r.getChild(0)).getNumChildren() == 1 && (t = t.getChild(0)) instanceof ASTPrimitiveType && ((ASTPrimitiveType)t).isBoolean()) {
            return super.visit(node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        if (!node.hasElse() && this.isIfJustReturnsBoolean(node) && this.isJustReturnsBooleanAfter(node)) {
            this.addViolation(data, (Node)node);
            return super.visit(node, data);
        }
        if (node.getNumChildren() != 3) {
            return super.visit(node, data);
        }
        if (((JavaNode)node.getChild(1)).getNumChildren() == 0 || ((JavaNode)node.getChild(2)).getNumChildren() == 0) {
            return super.visit(node, data);
        }
        JavaNode returnStatement1 = ((JavaNode)node.getChild(1)).getChild(0);
        JavaNode returnStatement2 = ((JavaNode)node.getChild(2)).getChild(0);
        if (returnStatement1 instanceof ASTReturnStatement && returnStatement2 instanceof ASTReturnStatement) {
            Node expression1 = returnStatement1.getChild(0).getChild(0);
            Node expression2 = returnStatement2.getChild(0).getChild(0);
            if (this.terminatesInBooleanLiteral((Node)returnStatement1) && this.terminatesInBooleanLiteral((Node)returnStatement2)) {
                this.addViolation(data, (Node)node);
            } else if (expression1 instanceof ASTUnaryExpressionNotPlusMinus ^ expression2 instanceof ASTUnaryExpressionNotPlusMinus && this.isNodesEqualWithUnaryExpression(expression1, expression2)) {
                this.addViolation(data, (Node)node);
            }
        } else if (this.hasOneBlockStmt(node.getChild(1)) && this.hasOneBlockStmt(node.getChild(2))) {
            returnStatement1 = returnStatement1.getChild(0).getChild(0).getChild(0);
            returnStatement2 = returnStatement2.getChild(0).getChild(0).getChild(0);
            if (this.isSimpleReturn((Node)returnStatement1) && this.isSimpleReturn((Node)returnStatement2)) {
                this.addViolation(data, (Node)node);
            } else {
                Node expression1 = this.getDescendant((Node)returnStatement1, 4);
                Node expression2 = this.getDescendant((Node)returnStatement2, 4);
                if (this.terminatesInBooleanLiteral((Node)((JavaNode)node.getChild(1)).getChild(0)) && this.terminatesInBooleanLiteral((Node)((JavaNode)node.getChild(2)).getChild(0))) {
                    this.addViolation(data, (Node)node);
                } else if (expression1 instanceof ASTUnaryExpressionNotPlusMinus ^ expression2 instanceof ASTUnaryExpressionNotPlusMinus && this.isNodesEqualWithUnaryExpression(expression1, expression2)) {
                    this.addViolation(data, (Node)node);
                }
            }
        }
        return super.visit(node, data);
    }

    private boolean isJustReturnsBooleanAfter(ASTIfStatement ifNode) {
        JavaNode blockStatement = ((JavaNode)ifNode.getParent()).getParent();
        Node block = blockStatement.getParent();
        if (block.getNumChildren() != blockStatement.getIndexInParent() + 1 + 1) {
            return false;
        }
        Node nextBlockStatement = block.getChild(blockStatement.getIndexInParent() + 1);
        return this.terminatesInBooleanLiteral(nextBlockStatement);
    }

    private boolean isIfJustReturnsBoolean(ASTIfStatement ifNode) {
        Node node = ifNode.getChild(1);
        return node.getNumChildren() == 1 && (this.hasOneBlockStmt(node) || this.terminatesInBooleanLiteral(node.getChild(0)));
    }

    private boolean hasOneBlockStmt(Node node) {
        return node.getChild(0) instanceof ASTBlock && node.getChild(0).getNumChildren() == 1 && this.terminatesInBooleanLiteral(node.getChild(0).getChild(0));
    }

    private Node getDescendant(Node node, int level) {
        Node n = node;
        for (int i = 0; i < level; ++i) {
            if (n.getNumChildren() == 0) {
                return null;
            }
            n = n.getChild(0);
        }
        return n;
    }

    private boolean terminatesInBooleanLiteral(Node node) {
        return this.eachNodeHasOneChild(node) && this.getLastChild(node) instanceof ASTBooleanLiteral;
    }

    private boolean eachNodeHasOneChild(Node node) {
        if (node.getNumChildren() > 1) {
            return false;
        }
        if (node.getNumChildren() == 0) {
            return true;
        }
        return this.eachNodeHasOneChild(node.getChild(0));
    }

    private Node getLastChild(Node node) {
        if (node.getNumChildren() == 0) {
            return node;
        }
        return this.getLastChild(node.getChild(0));
    }

    private boolean isNodesEqualWithUnaryExpression(Node n1, Node n2) {
        Node node1 = n1 instanceof ASTUnaryExpressionNotPlusMinus ? n1.getChild(0) : n1;
        Node node2 = n2 instanceof ASTUnaryExpressionNotPlusMinus ? n2.getChild(0) : n2;
        return this.isNodesEquals(node1, node2);
    }

    private boolean isNodesEquals(Node n1, Node n2) {
        int numberChild2;
        int numberChild1 = n1.getNumChildren();
        if (numberChild1 != (numberChild2 = n2.getNumChildren())) {
            return false;
        }
        if (!n1.getClass().equals(n2.getClass())) {
            return false;
        }
        if (!n1.toString().equals(n2.toString())) {
            return false;
        }
        for (int i = 0; i < numberChild1; ++i) {
            if (this.isNodesEquals(n1.getChild(i), n2.getChild(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isSimpleReturn(Node node) {
        return node instanceof ASTReturnStatement && node.getNumChildren() == 0;
    }
}

