/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.metrics.api.JavaClassMetricKey;
import net.sourceforge.pmd.lang.java.metrics.api.JavaOperationMetricKey;
import net.sourceforge.pmd.lang.java.metrics.impl.CycloMetric;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaMetricsRule;
import net.sourceforge.pmd.lang.metrics.MetricKey;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.ResultOption;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.constraints.NumericConstraints;

public class CyclomaticComplexityRule
extends AbstractJavaMetricsRule {
    private static final Logger LOG = Logger.getLogger(CyclomaticComplexityRule.class.getName());
    @Deprecated
    private static final PropertyDescriptor<Integer> REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"reportLevel").desc("Deprecated! Cyclomatic Complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)10)).build();
    private static final PropertyDescriptor<Integer> CLASS_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"classReportLevel").desc("Total class complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)80)).build();
    private static final PropertyDescriptor<Integer> METHOD_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"methodReportLevel").desc("Cyclomatic complexity reporting threshold")).require(NumericConstraints.positive())).defaultValue((Object)10)).build();
    private static final Map<String, CycloMetric.CycloOption> OPTION_MAP = new HashMap<String, CycloMetric.CycloOption>();
    private static final PropertyDescriptor<List<CycloMetric.CycloOption>> CYCLO_OPTIONS_DESCRIPTOR;
    private int methodReportLevel;
    private int classReportLevel;
    private MetricOptions cycloOptions;

    public CyclomaticComplexityRule() {
        this.definePropertyDescriptor(CLASS_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(METHOD_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(CYCLO_OPTIONS_DESCRIPTOR);
        this.definePropertyDescriptor(REPORT_LEVEL_DESCRIPTOR);
    }

    private void assignReportLevelsCompat() {
        int methodLevel = (Integer)this.getProperty(METHOD_LEVEL_DESCRIPTOR);
        int classLevel = (Integer)this.getProperty(CLASS_LEVEL_DESCRIPTOR);
        int commonLevel = (Integer)this.getProperty(REPORT_LEVEL_DESCRIPTOR);
        if (methodLevel == (Integer)METHOD_LEVEL_DESCRIPTOR.defaultValue() && classLevel == (Integer)CLASS_LEVEL_DESCRIPTOR.defaultValue() && commonLevel != (Integer)REPORT_LEVEL_DESCRIPTOR.defaultValue()) {
            LOG.warning("Rule CyclomaticComplexity uses deprecated property 'reportLevel'. Future versions of PMD will remove support for this property. Please use 'methodReportLevel' and 'classReportLevel' instead!");
            methodLevel = commonLevel;
            classLevel = commonLevel * 8;
        }
        this.methodReportLevel = methodLevel;
        this.classReportLevel = classLevel;
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        this.assignReportLevelsCompat();
        this.cycloOptions = MetricOptions.ofOptions((Collection)((Collection)this.getProperty(CYCLO_OPTIONS_DESCRIPTOR)));
        super.visit(node, data);
        return data;
    }

    @Override
    public Object visit(ASTAnyTypeDeclaration node, Object data) {
        int classWmc;
        super.visit(node, data);
        if (JavaClassMetricKey.WMC.supports(node) && (classWmc = (int)JavaMetrics.get(JavaClassMetricKey.WMC, node, this.cycloOptions)) >= this.classReportLevel) {
            int classHighest = (int)JavaMetrics.get(JavaOperationMetricKey.CYCLO, node, this.cycloOptions, ResultOption.HIGHEST);
            Object[] messageParams = new String[]{PrettyPrintingUtil.kindName(node), node.getSimpleName(), " total", classWmc + " (highest " + classHighest + ")"};
            this.addViolation(data, node, messageParams);
        }
        return data;
    }

    @Override
    public final Object visit(MethodLikeNode node, Object data) {
        int cyclo = (int)JavaMetrics.get((MetricKey<MethodLikeNode>)JavaOperationMetricKey.CYCLO, node, this.cycloOptions);
        if (cyclo >= this.methodReportLevel) {
            String opname;
            String string = opname = node instanceof ASTMethodOrConstructorDeclaration ? PrettyPrintingUtil.displaySignature((ASTMethodOrConstructorDeclaration)node) : "lambda";
            String kindname = node instanceof ASTMethodOrConstructorDeclaration ? (node instanceof ASTConstructorDeclaration ? "constructor" : "method") : "lambda";
            this.addViolation(data, node, new String[]{kindname, opname, "", "" + cyclo});
        }
        return data;
    }

    static {
        OPTION_MAP.put(CycloMetric.CycloOption.IGNORE_BOOLEAN_PATHS.valueName(), CycloMetric.CycloOption.IGNORE_BOOLEAN_PATHS);
        OPTION_MAP.put(CycloMetric.CycloOption.CONSIDER_ASSERT.valueName(), CycloMetric.CycloOption.CONSIDER_ASSERT);
        CYCLO_OPTIONS_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.enumListProperty((String)"cycloOptions", OPTION_MAP).desc("Choose options for the computation of Cyclo")).emptyDefaultValue().build();
    }
}

