/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.impl;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.MethodLikeNode;
import net.sourceforge.pmd.lang.java.metrics.impl.AbstractJavaOperationMetric;
import net.sourceforge.pmd.lang.java.metrics.impl.internal.CycloVisitor;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.apache.commons.lang3.mutable.MutableInt;

public final class CycloMetric
extends AbstractJavaOperationMetric {
    public double computeFor(MethodLikeNode node, MetricOptions options) {
        MutableInt cyclo = (MutableInt)node.jjtAccept(new CycloVisitor(options, node), new MutableInt(1));
        return cyclo.getValue().intValue();
    }

    public static int booleanExpressionComplexity(Node expr) {
        if (expr == null) {
            return 0;
        }
        List andNodes = expr.findDescendantsOfType(ASTConditionalAndExpression.class);
        List orNodes = expr.findDescendantsOfType(ASTConditionalOrExpression.class);
        int complexity = 0;
        if (expr instanceof ASTConditionalOrExpression || expr instanceof ASTConditionalAndExpression) {
            ++complexity;
        }
        for (AbstractJavaTypeNode element : orNodes) {
            complexity += element.getNumChildren() - 1;
        }
        for (AbstractJavaTypeNode element : andNodes) {
            complexity += element.getNumChildren() - 1;
        }
        return complexity;
    }

    public static enum CycloOption implements MetricOption
    {
        IGNORE_BOOLEAN_PATHS("ignoreBooleanPaths"),
        CONSIDER_ASSERT("considerAssert");

        private final String vName;

        private CycloOption(String valueName) {
            this.vName = valueName;
        }

        public String valueName() {
            return this.vName;
        }
    }
}

