/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.functionalrenderer;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.coode.owlapi.functionalrenderer.OWLObjectRenderer;
import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.util.AbstractOWLOntologyStorer;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class OWLFunctionalSyntaxOntologyStorer
extends AbstractOWLOntologyStorer {
    private static final long serialVersionUID = 30406L;

    public boolean canStoreOntology(OWLOntologyFormat ontologyFormat) {
        return ontologyFormat.equals((Object)new OWLFunctionalSyntaxOntologyFormat());
    }

    protected void storeOntology(OWLOntologyManager manager, OWLOntology ontology, Writer writer, OWLOntologyFormat format) throws OWLOntologyStorageException {
        this.storeOntology(ontology, writer, format);
    }

    protected void storeOntology(OWLOntology ontology, Writer writer, OWLOntologyFormat format) throws OWLOntologyStorageException {
        try {
            OWLObjectRenderer ren = new OWLObjectRenderer(ontology, writer);
            if (format instanceof PrefixOWLOntologyFormat) {
                PrefixOWLOntologyFormat prefixFormat = (PrefixOWLOntologyFormat)format;
                DefaultPrefixManager man = new DefaultPrefixManager();
                Map map = prefixFormat.getPrefixName2PrefixMap();
                for (Map.Entry e : map.entrySet()) {
                    man.setPrefix((String)e.getKey(), (String)e.getValue());
                }
                ren.setPrefixManager(man);
            }
            ontology.accept((OWLObjectVisitor)ren);
            writer.flush();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
    }
}

