/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.messaging.util.StreamUtils;
import org.jboss.messaging.util.Streamable;

class MappingInfo
implements Streamable {
    private int nodeId;
    private String conditionText;
    private String filterString;
    private long channelId;
    private boolean recoverable;
    private int maxSize;
    private String queueName;
    private boolean clustered;
    private int fullSize;
    private int pageSize;
    private int downCacheSize;
    private boolean allNodes;
    private long recoverDeliveriesTimeout;

    MappingInfo() {
    }

    MappingInfo(int nodeId, String queueName, String conditionText, String filterString, long channelId, boolean recoverable, boolean clustered, boolean allNodes) {
        this.nodeId = nodeId;
        this.queueName = queueName;
        this.conditionText = conditionText;
        this.filterString = filterString;
        this.channelId = channelId;
        this.recoverable = recoverable;
        this.clustered = clustered;
        this.allNodes = allNodes;
    }

    MappingInfo(int nodeId, String queueName, String conditionText, String filterString, long channelId, boolean recoverable, boolean clustered, boolean allNodes, int fullSize, int pageSize, int downCacheSize, int maxSize, long recoverDeliveriesTimeout) {
        this(nodeId, queueName, conditionText, filterString, channelId, recoverable, clustered, allNodes);
        this.fullSize = fullSize;
        this.pageSize = pageSize;
        this.downCacheSize = downCacheSize;
        this.maxSize = maxSize;
        this.recoverDeliveriesTimeout = recoverDeliveriesTimeout;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        this.queueName = in.readUTF();
        this.conditionText = in.readUTF();
        this.filterString = (String)StreamUtils.readObject(in, false);
        this.channelId = in.readLong();
        this.recoverable = in.readBoolean();
        this.clustered = in.readBoolean();
        this.allNodes = in.readBoolean();
        this.fullSize = in.readInt();
        this.pageSize = in.readInt();
        this.downCacheSize = in.readInt();
        this.maxSize = in.readInt();
        this.recoverDeliveriesTimeout = in.readLong();
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        out.writeUTF(this.queueName);
        out.writeUTF(this.conditionText);
        StreamUtils.writeObject(out, this.filterString, false, false);
        out.writeLong(this.channelId);
        out.writeBoolean(this.recoverable);
        out.writeBoolean(this.clustered);
        out.writeBoolean(this.allNodes);
        out.writeInt(this.fullSize);
        out.writeInt(this.pageSize);
        out.writeInt(this.downCacheSize);
        out.writeInt(this.maxSize);
        out.writeLong(this.recoverDeliveriesTimeout);
    }

    int getNodeId() {
        return this.nodeId;
    }

    String getQueueName() {
        return this.queueName;
    }

    long getChannelId() {
        return this.channelId;
    }

    String getConditionText() {
        return this.conditionText;
    }

    boolean isRecoverable() {
        return this.recoverable;
    }

    String getFilterString() {
        return this.filterString;
    }

    boolean isClustered() {
        return this.clustered;
    }

    boolean isAllNodes() {
        return this.allNodes;
    }

    int getFullSize() {
        return this.fullSize;
    }

    int getPageSize() {
        return this.pageSize;
    }

    int getDownCacheSize() {
        return this.downCacheSize;
    }

    int getMaxSize() {
        return this.maxSize;
    }

    long getRecoverDeliveriesTimeout() {
        return this.recoverDeliveriesTimeout;
    }
}

