/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import org.jboss.jms.exception.MessagingJMSException;
import org.jboss.jms.message.JBossMessage;
import org.jboss.logging.Logger;

public class JBossBytesMessage
extends JBossMessage
implements BytesMessage {
    private static final long serialVersionUID = 5914561890366707664L;
    private static final Logger log = Logger.getLogger(JBossBytesMessage.class);
    public static final byte TYPE = 4;
    private boolean trace = log.isTraceEnabled();
    private transient ByteArrayOutputStream baos;
    private transient DataOutputStream dos;
    private transient ByteArrayInputStream bais;
    private transient DataInputStream dis;

    public JBossBytesMessage() {
    }

    public JBossBytesMessage(long messageID) {
        super(messageID);
    }

    public JBossBytesMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map coreHeaders, byte[] payloadAsByteArray) {
        super(messageID, reliable, expiration, timestamp, priority, coreHeaders, payloadAsByteArray);
    }

    public JBossBytesMessage(JBossBytesMessage other) {
        super(other);
        if (this.trace) {
            log.trace((Object)"Creating new JBossBytesMessage from other JBossBytesMessage");
        }
    }

    public JBossBytesMessage(BytesMessage foreign, long id) throws JMSException {
        super((Message)foreign, id);
        foreign.reset();
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        byte[] buffer = new byte[1024];
        int n = foreign.readBytes(buffer);
        while (n != -1) {
            this.writeBytes(buffer, 0, n);
            n = foreign.readBytes(buffer);
        }
    }

    public void read(DataInputStream in) throws Exception {
        super.read(in);
    }

    public boolean readBoolean() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readBoolean();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public byte readByte() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public int readUnsignedByte() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readUnsignedByte();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public short readShort() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public int readUnsignedShort() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readUnsignedShort();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public char readChar() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readChar();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public int readInt() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readInt();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public long readLong() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readLong();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public float readFloat() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readFloat();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public double readDouble() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readDouble();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public String readUTF() throws JMSException {
        this.checkRead();
        try {
            return this.dis.readUTF();
        }
        catch (EOFException e) {
            throw new MessageEOFException("");
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public int readBytes(byte[] value) throws JMSException {
        this.checkRead();
        try {
            return this.dis.read(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        this.checkRead();
        try {
            return this.dis.read(value, 0, length);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeBoolean(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeByte(byte value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeByte(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeShort(short value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeShort(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeChar(char value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeChar(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeInt(int value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeInt(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeLong(long value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeLong(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeFloat(float value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeFloat(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeDouble(double value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeDouble(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeUTF(String value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.writeUTF(value);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeBytes(byte[] value) throws JMSException {
        this.checkWrite();
        try {
            this.dos.write(value, 0, value.length);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        this.checkWrite();
        try {
            this.dos.write(value, offset, length);
        }
        catch (IOException e) {
            throw new MessagingJMSException("IOException", e);
        }
    }

    public void writeObject(Object value) throws JMSException {
        block12: {
            this.checkWrite();
            try {
                if (value == null) {
                    throw new NullPointerException("Attempt to write a new value");
                }
                if (value instanceof String) {
                    this.dos.writeUTF((String)value);
                    break block12;
                }
                if (value instanceof Boolean) {
                    this.dos.writeBoolean((Boolean)value);
                    break block12;
                }
                if (value instanceof Byte) {
                    this.dos.writeByte(((Byte)value).byteValue());
                    break block12;
                }
                if (value instanceof Short) {
                    this.dos.writeShort(((Short)value).shortValue());
                    break block12;
                }
                if (value instanceof Integer) {
                    this.dos.writeInt((Integer)value);
                    break block12;
                }
                if (value instanceof Long) {
                    this.dos.writeLong((Long)value);
                    break block12;
                }
                if (value instanceof Float) {
                    this.dos.writeFloat(((Float)value).floatValue());
                    break block12;
                }
                if (value instanceof Double) {
                    this.dos.writeDouble((Double)value);
                    break block12;
                }
                if (value instanceof byte[]) {
                    this.dos.write((byte[])value, 0, ((byte[])value).length);
                    break block12;
                }
                throw new MessageFormatException("Invalid object for properties");
            }
            catch (IOException e) {
                throw new MessagingJMSException("IOException", e);
            }
        }
    }

    public void reset() throws JMSException {
        try {
            if (this.baos != null) {
                this.dos.flush();
                this.payload = this.baos.toByteArray();
                this.payloadAsByteArray = (byte[])this.payload;
                this.baos.close();
            }
            this.baos = null;
            this.bais = null;
            this.dis = null;
            this.dos = null;
        }
        catch (Exception e) {
            JMSException e2 = new JMSException(e.getMessage());
            e2.setStackTrace(e.getStackTrace());
            throw e2;
        }
    }

    public Object getPayload() {
        return this.payload;
    }

    public byte[] getPayloadAsByteArray() {
        return this.payloadAsByteArray;
    }

    public void doBeforeSend() throws JMSException {
        this.reset();
    }

    public void doBeforeReceive() throws JMSException {
        this.reset();
    }

    public void clearBody() throws JMSException {
        try {
            if (this.baos != null) {
                this.baos.close();
            } else if (this.bais != null) {
                this.bais.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        this.payload = null;
        this.payloadAsByteArray = null;
        this.bais = null;
        this.dis = null;
    }

    public long getBodyLength() throws JMSException {
        this.checkRead();
        return this.payloadAsByteArray.length;
    }

    public byte getType() {
        return 4;
    }

    public JBossMessage doCopy() throws JMSException {
        this.reset();
        return new JBossBytesMessage(this);
    }

    public void copyPayload(Object payload) throws JMSException {
        byte[] otherBytes = (byte[])payload;
        if (otherBytes == null) {
            payload = null;
        } else {
            payload = new byte[otherBytes.length];
            System.arraycopy(otherBytes, 0, payload, 0, otherBytes.length);
            this.payloadAsByteArray = (byte[])payload;
        }
    }

    void checkRead() {
        if (this.bais == null) {
            if (this.payloadAsByteArray == null) {
                this.payloadAsByteArray = new byte[0];
            }
            this.bais = new ByteArrayInputStream(this.payloadAsByteArray);
            this.dis = new DataInputStream(this.bais);
        }
    }

    void checkWrite() {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
        }
    }
}

