/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.brave.sampler;

import com.github.kristofa.brave.Sampler;
import com.github.kristofa.brave.internal.Util;
import java.io.Closeable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.BackgroundPathable;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

public final class ZooKeeperSampler
extends Sampler
implements Watcher,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(ZooKeeperSampler.class.getName());
    private static final float DEFAULT_SAMPLE_RATE = 0.0f;
    private final CuratorFramework zkCurator;
    private final CountDownLatch connectionEstablished = new CountDownLatch(1);
    private final String sampleRateZNode;
    private volatile Sampler delegate;

    public boolean isSampled(long traceId) {
        return this.delegate.isSampled(traceId);
    }

    public ZooKeeperSampler(String connectionString, String sampleRateZNode) throws InterruptedException {
        Util.checkNotBlank((String)connectionString, (String)"Null or blank connectionString", (Object[])new Object[0]);
        this.sampleRateZNode = Util.checkNotBlank((String)sampleRateZNode, (String)"Null or blank sampleRateZNode", (Object[])new Object[0]);
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
        this.zkCurator = CuratorFrameworkFactory.newClient((String)connectionString, (RetryPolicy)retryPolicy);
        InitialConnectionStateListener initialConnectionState = new InitialConnectionStateListener();
        this.zkCurator.getConnectionStateListenable().addListener((Object)initialConnectionState);
        this.zkCurator.start();
        if (!this.connectionEstablished.await(2L, TimeUnit.SECONDS)) {
            this.zkCurator.close();
            throw new IllegalStateException("Connection with ZooKeeper failed.");
        }
        this.zkCurator.getConnectionStateListenable().removeListener((Object)initialConnectionState);
        this.delegate = Sampler.create((float)this.getSampleRate());
    }

    public void process(WatchedEvent event) {
        String path;
        if ((event.getType().equals((Object)Watcher.Event.EventType.NodeDataChanged) || event.getType().equals((Object)Watcher.Event.EventType.NodeCreated) || event.getType().equals((Object)Watcher.Event.EventType.NodeDeleted)) && this.sampleRateZNode.equals(path = event.getPath())) {
            float newRate = this.getSampleRate();
            this.delegate = Sampler.create((float)newRate);
            LOGGER.info(String.format("SampleRate znode [%s] changed. New value: %s", this.sampleRateZNode, Float.valueOf(newRate)));
        }
    }

    @Override
    public void close() {
        this.zkCurator.close();
    }

    CuratorFramework getZkCurator() {
        return this.zkCurator;
    }

    private float getSampleRate() {
        byte[] data = this.getData(this.sampleRateZNode);
        if (data == null) {
            return 0.0f;
        }
        return Float.valueOf(new String(data, Util.UTF_8)).floatValue();
    }

    private byte[] getData(String znode) {
        try {
            Stat stat = (Stat)((BackgroundPathable)this.zkCurator.checkExists().usingWatcher((Watcher)this)).forPath(znode);
            if (stat != null) {
                return (byte[])((BackgroundPathable)this.zkCurator.getData().usingWatcher((Watcher)this)).forPath(znode);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Zookeeper exception.", e);
        }
        return null;
    }

    private class InitialConnectionStateListener
    implements ConnectionStateListener {
        private InitialConnectionStateListener() {
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            if (ConnectionState.CONNECTED.equals((Object)newState) || ConnectionState.RECONNECTED.equals((Object)newState)) {
                LOGGER.info("Connected with ZooKeeper.");
                ZooKeeperSampler.this.connectionEstablished.countDown();
            }
        }
    }
}

