/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import io.vertx.ext.auth.PRNG;
import io.vertx.ext.mail.impl.sasl.AuthCram;
import io.vertx.ext.mail.impl.sasl.AuthDigest;
import io.vertx.ext.mail.impl.sasl.AuthLogin;
import io.vertx.ext.mail.impl.sasl.AuthOperation;
import io.vertx.ext.mail.impl.sasl.AuthPlain;
import io.vertx.ext.mail.impl.sasl.AuthXOAUTH2;
import java.util.Set;

public final class AuthOperationFactory {
    private static final String[] ALGORITHMS = new String[]{"XOAUTH2", "DIGEST-MD5", "CRAM-SHA256", "CRAM-SHA1", "CRAM-MD5", "PLAIN", "LOGIN"};
    private final PRNG prng;

    public AuthOperationFactory(PRNG prng) {
        this.prng = prng;
    }

    public AuthOperation createAuth(String username, String password, Set<String> allowedMethods) {
        for (String algorithm : ALGORITHMS) {
            if (!allowedMethods.contains(algorithm)) continue;
            switch (algorithm) {
                case "XOAUTH2": {
                    return new AuthXOAUTH2(username, password);
                }
                case "CRAM-MD5": {
                    return new AuthCram("CRAM-MD5", username, password);
                }
                case "CRAM-SHA1": {
                    return new AuthCram("CRAM-SHA1", username, password);
                }
                case "CRAM-SHA256": {
                    return new AuthCram("CRAM-SHA256", username, password);
                }
                case "DIGEST-MD5": {
                    return new AuthDigest("DIGEST-MD5", this.prng, username, password);
                }
                case "PLAIN": {
                    return new AuthPlain(username, password);
                }
                case "LOGIN": {
                    return new AuthLogin(username, password);
                }
            }
        }
        return null;
    }
}

