/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathDirectory;
import io.takari.maven.plugins.compile.jdt.classpath.ClasspathJar;
import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.SourcepathDirectory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;

@Named
public class ClasspathEntryCache {
    private static final Map<File, DependencyClasspathEntry> CACHE = new HashMap<File, DependencyClasspathEntry>();
    private static final Map<File, DependencyClasspathEntry> SOURCEPATH_CACHE = new HashMap<File, DependencyClasspathEntry>();

    public DependencyClasspathEntry get(File location) {
        return ClasspathEntryCache.get(CACHE, location, () -> {
            DependencyClasspathEntry entry = null;
            if (location.isDirectory()) {
                entry = ClasspathDirectory.create(location);
            } else if (location.isFile()) {
                try {
                    entry = ClasspathJar.create(location);
                }
                catch (IOException iOException) {}
            }
            return entry;
        });
    }

    public DependencyClasspathEntry getSourcepathEntry(File location, Charset encoding) {
        return ClasspathEntryCache.get(SOURCEPATH_CACHE, location, () -> SourcepathDirectory.create(location, encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DependencyClasspathEntry get(Map<File, DependencyClasspathEntry> cache, File location, Factory factory) {
        location = ClasspathEntryCache.normalize(location);
        Map<File, DependencyClasspathEntry> map = cache;
        synchronized (map) {
            DependencyClasspathEntry entry = null;
            if (!cache.containsKey(location)) {
                entry = factory.newClasspathEntry();
                cache.put(location, entry);
            } else {
                entry = cache.get(location);
            }
            return entry;
        }
    }

    private static File normalize(File location) {
        try {
            location = location.getCanonicalFile();
        }
        catch (IOException iOException) {
            location = location.getAbsoluteFile();
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        Map<File, DependencyClasspathEntry> map = CACHE;
        synchronized (map) {
            CACHE.clear();
        }
        map = SOURCEPATH_CACHE;
        synchronized (map) {
            SOURCEPATH_CACHE.clear();
        }
    }

    private static interface Factory {
        public DependencyClasspathEntry newClasspathEntry();
    }
}

