/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.Xml;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.schema.ModelPropertyBuilderPlugin;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Component
public class XmlPropertyPlugin
implements ModelPropertyBuilderPlugin {
    public void apply(ModelPropertyContext context) {
        Optional elementAnnotation = Optional.absent();
        Optional attributeAnnotation = Optional.absent();
        if (context.getAnnotatedElement().isPresent()) {
            elementAnnotation = elementAnnotation.or(XmlPropertyPlugin.findAnnotation((AnnotatedElement)context.getAnnotatedElement().get(), XmlElement.class));
            attributeAnnotation = attributeAnnotation.or(XmlPropertyPlugin.findAnnotation((AnnotatedElement)context.getAnnotatedElement().get(), XmlAttribute.class));
        }
        if (context.getBeanPropertyDefinition().isPresent()) {
            elementAnnotation = elementAnnotation.or(Annotations.findPropertyAnnotation((BeanPropertyDefinition)context.getBeanPropertyDefinition().get(), XmlElement.class));
            attributeAnnotation = attributeAnnotation.or(Annotations.findPropertyAnnotation((BeanPropertyDefinition)context.getBeanPropertyDefinition().get(), XmlAttribute.class));
        }
        if (elementAnnotation.isPresent()) {
            Optional<XmlElementWrapper> wrapper = Annotations.findPropertyAnnotation((BeanPropertyDefinition)context.getBeanPropertyDefinition().get(), XmlElementWrapper.class);
            context.getBuilder().xml(new Xml().attribute(Boolean.valueOf(false)).namespace(this.defaultToNull(((XmlElement)elementAnnotation.get()).namespace())).name(this.wrapperName(wrapper, (Optional<XmlElement>)elementAnnotation)).wrapped(Boolean.valueOf(wrapper.isPresent())));
        } else if (attributeAnnotation.isPresent()) {
            context.getBuilder().xml(new Xml().attribute(Boolean.valueOf(true)).namespace(this.defaultToNull(((XmlAttribute)attributeAnnotation.get()).namespace())).name(this.attributeName((Optional<XmlAttribute>)attributeAnnotation)).wrapped(Boolean.valueOf(false)));
        }
    }

    public static <T extends Annotation> Optional<T> findAnnotation(AnnotatedElement annotated, Class<T> annotation) {
        return Optional.fromNullable((Object)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, annotation));
    }

    private String wrapperName(Optional<XmlElementWrapper> wrapper, Optional<XmlElement> element) {
        if (wrapper.isPresent()) {
            return (String)Optional.fromNullable((Object)this.defaultToNull(Strings.emptyToNull((String)((XmlElementWrapper)wrapper.get()).name()))).or(Optional.fromNullable((Object)this.elementName(element))).orNull();
        }
        return this.elementName(element);
    }

    private String elementName(Optional<XmlElement> element) {
        if (element.isPresent()) {
            return this.defaultToNull(Strings.emptyToNull((String)((XmlElement)element.get()).name()));
        }
        return null;
    }

    private String attributeName(Optional<XmlAttribute> attribute) {
        if (attribute.isPresent()) {
            return this.defaultToNull(Strings.emptyToNull((String)((XmlAttribute)attribute.get()).name()));
        }
        return null;
    }

    private String defaultToNull(String value) {
        return "##default".equalsIgnoreCase(value) ? null : value;
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }
}

